//
//  CountDownManager.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 25/10/23.
//

import Foundation
class CountdownManager {
    var timer: Timer?
    var secondsRemaining = 0

    func startCountdown(seconds: Int, updateLabel: @escaping (String) -> Void, completion: @escaping () -> Void) {
        self.secondsRemaining = seconds

        timer = Timer.scheduledTimer(withTimeInterval: 1, repeats: true) { [weak self] timer in
            guard let self = self else {
                timer.invalidate()
                return
            }
            if self.secondsRemaining > 0 {
                let minutes = self.secondsRemaining / 60
                let seconds = self.secondsRemaining % 60
                let timeString = String(format: "%02d:%02d", minutes, seconds)
                updateLabel(timeString)
                self.secondsRemaining -= 1
            } else {
                timer.invalidate()
                completion()
            }
        }
    }

    func stopCountdown() {
        timer?.invalidate()
    }
}

