import Foundation



// MARK: - Base Protocols
protocol BaseResponse: Codable {
    var code: String { get }
    var message: String { get }
    var messageKh: String { get }
}

protocol LocalizedContent {
    var nameKh: String { get }
}

// MARK: - Base Classes
class BaseModel: Codable {
    let id: String

    enum CodingKeys: String, CodingKey {
        case id
    }

    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.id = try container.decode(String.self, forKey: .id)
    }
}

// MARK: - API Response
struct ApiResponse<T: Codable>: BaseResponse {
    let code: String
    let message: String
    let messageKh: String
    let data: T

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}
