//
//  DWalletMode.swift
//  B24PaymentSdk
//
//  Created by visal ny on 19/12/24.
//

import Foundation

struct DWalletMode: Codable{
    let primaryColor, screenBgColor, primaryLabelColor, secondaryLabelColor: String
    let cardColor, onPrimaryColor, dangerColor, warningColor: String
    
    enum CodingKeys: String, CodingKey {
            case primaryColor = "primary_color"
            case screenBgColor = "screen_bg_color"
            case primaryLabelColor = "primary_label_color"
            case secondaryLabelColor = "secondary_label_color"
            case cardColor = "card_color"
            case onPrimaryColor = "on_primary_color"
            case dangerColor = "danger_color"
            case warningColor = "warning_color"
        }
    
    
    init(
            primaryColor: String = "#0064EF",
            screenBgColor: String = "#F2F2F2",
            primaryLabelColor: String = "#06417D",
            secondaryLabelColor: String = "#06417D",
            cardColor: String = "#FFFFFF",
            onPrimaryColor: String = "#FFFFFF",
            dangerColor: String = "#FE608A",
            warningColor: String = "#FFC668"
        ) {
            self.primaryColor = primaryColor
            self.screenBgColor = screenBgColor
            self.primaryLabelColor = primaryLabelColor
            self.secondaryLabelColor = secondaryLabelColor
            self.cardColor = cardColor
            self.onPrimaryColor = onPrimaryColor
            self.dangerColor = dangerColor
            self.warningColor = warningColor
        }
}
