//
//  DWalletTransactionResponseModel.swift
//  B24PaymentSdk
//
//  Created by visal ny on 26/12/24.
//

import Foundation


// MARK: - TransactionResponseModel
struct DWalletTransactionResponseModel: Codable {
    let code, message, messageKh: String
    let data: DataTransaction

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct DataTransaction: Codable {
    let accountNo: String?
    let transactions: [DWalletTransaction]
    let pagination: Pagination

    enum CodingKeys: String, CodingKey {
        case accountNo = "account_no"
        case transactions, pagination
    }
}

// MARK: - Pagination
struct Pagination: Codable {
    let currentPage, pageSize, totalPages, totalItems: Int
    let hasNextPage, hasPreviousPage: Bool

    enum CodingKeys: String, CodingKey {
        case currentPage = "current_page"
        case pageSize = "page_size"
        case totalPages = "total_pages"
        case totalItems = "total_items"
        case hasNextPage = "has_next_page"
        case hasPreviousPage = "has_previous_page"
    }
}

// MARK: - Transaction
struct DWalletTransaction: Codable {
    let tranType, tranID: String
    let amount: Double
    let amountDisplay, currency, tranDate, descriptionEn, descriptionKm: String

    enum CodingKeys: String, CodingKey {
        case tranType = "tran_type"
        case tranID = "tran_id"
        case amount
        case amountDisplay = "amount_display"
        case currency
        case tranDate = "tran_date"
        case descriptionEn = "description_en"
        case descriptionKm = "description_km"
    }
    
    init(
            tranType: String = "wallet_topup",
            tranID: String = "5d2f826a-ad0e-4a95-af11-26c05c0efd19",
            amount: Double = 10.0000,
            amountDisplay: String = "10.00",
            currency: String = "USD",
            tranDate: String = "2024-12-13 11:37:56",
            descriptionEn: String = "",
            descrptionKm: String = ""
        ) {
            self.tranType = tranType
            self.tranID = tranID
            self.amount = amount
            self.amountDisplay = amountDisplay
            self.currency = currency
            self.tranDate = tranDate
            self.descriptionEn = descriptionEn
            self.descriptionKm = descrptionKm
        }
}
