//
//  GenerateLinkResponseModel.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 29/10/23.
//

import Foundation

struct GenerateLinkResponse: Codable {
    let code, message, messageKh: String?
    let data: GenerateLinkData?

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct GenerateLinkData: Codable {
    let webPaymentURL: String
    let mobileDeepLink: String

    enum CodingKeys: String, CodingKey {
        case webPaymentURL = "web_payment_url"
        case mobileDeepLink = "mobile_deep_link"
    }
}
