//
//  CheckoutDetailRouter.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 20/10/23.
//

import Foundation
import Alamofire

enum CheckoutRouter : URLRequestConvertible{
    case checkoutDetail(transactionId: String)
    case generateLink(bankId: String,transactionId: String)
    case updateTransactionExpire(transactionId: String)
    case addToFavorite(transactionId: String, bankId: String, isFavorite: Bool)
    
    var params: Parameters{
        switch self {
        case .checkoutDetail(let transactionId),.updateTransactionExpire(let transactionId):
            return ["tran_id": transactionId]
        case .generateLink(let bankId, let transactionId):
            return ["bank_id": bankId, "tran_id": transactionId]
        case .addToFavorite(let transactionId, let bankId, let isFavorite):
            return ["tran_id": transactionId, "bank_id": bankId, "is_favorite": isFavorite]
        }
    }
    var path: String{
        switch self {
        case .checkoutDetail:
            return "/checkout/detail"
        case .updateTransactionExpire:
            return "/checkout/extend_expire_date"
        case .addToFavorite:
            return "/checkout/favorite_bank"
        case .generateLink:
            return "/checkout/generate_links"
        }
    }
 
    func asURLRequest() throws -> URLRequest {
           let url =  APIManager.merchantApiUrl().appendingPathComponent(path)
           var request = URLRequest(url: url)
           request.method = .post
           request.allowsConstrainedNetworkAccess = true
           request.allowsExpensiveNetworkAccess = true

           switch self {
           case .checkoutDetail, .addToFavorite, .generateLink:
               request.headers = APIManager.initHeader()
           case .updateTransactionExpire:
               request.headers = APIManager.initHeaderExtendExpireDate()
           }
           request = try JSONEncoding.default.encode(request, with: params)
           return request
       }
}
