//import UIKit
//import Alamofire
//
//class InstantPaymentMethodViewController: UIViewController{
//
//    private var paymentMethods: [PaymentMethodModel] = []
//    private var isLoading = false
//    
// 
//
//    private lazy var refreshControl: UIRefreshControl = {
//        let refreshControl = UIRefreshControl()
//        refreshControl.addTarget(self, action: #selector(refreshPaymentMethods), for: .valueChanged)
//        return refreshControl
//    }()
//
//    private lazy var paymentMethodsCollectionView: UICollectionView = {
//        let layout = UICollectionViewFlowLayout()
//        layout.scrollDirection = .vertical
//        layout.minimumInteritemSpacing = 10
//        layout.minimumLineSpacing = 15
//
//        let collectionView = UICollectionView(frame: .zero, collectionViewLayout: layout)
//        collectionView.backgroundColor = DefaultAppearance.shared.screenBgColor
//        collectionView.translatesAutoresizingMaskIntoConstraints = false
//        collectionView.showsVerticalScrollIndicator = false
//        collectionView.register(PaymentMethodCell.self, forCellWithReuseIdentifier: "PaymentMethodCell")
//        collectionView.register(InactivePaymentMethodCell.self, forCellWithReuseIdentifier: "InactivePaymentMethodCell")
//        collectionView.refreshControl = refreshControl
//        return collectionView
//    }()
//
//    @objc private func refreshPaymentMethods() {
//        fetchPaymentMethods()
//        DispatchQueue.main.asyncAfter(deadline: .now() + 1.5) {
//            self.refreshControl.endRefreshing()
//        }
//    }
//
//    private lazy var headerView: UIView = {
//        let view = UIView()
//        view.backgroundColor = DefaultAppearance.shared.screenBgColor
//        view.translatesAutoresizingMaskIntoConstraints = false
//        return view
//    }()
//
//    private lazy var backButton: UIButton = {
//        let button = UIButton(type: .system)
//        button.setImage(UIImage(systemName: "chevron.left"), for: .normal)
//        button.tintColor = .systemBlue
//        button.translatesAutoresizingMaskIntoConstraints = false
//        button.addTarget(self, action: #selector(backButtonTapped), for: .touchUpInside)
//        return button
//    }()
//
//    private lazy var addButton: UIButton = {
//        let button = UIButton(type: .system)
//        button.translatesAutoresizingMaskIntoConstraints = false
//        button.backgroundColor = DefaultAppearance.shared.primaryColor
//        button.tintColor = DefaultAppearance.shared.onPrimaryColor
//        button.layer.cornerRadius = 28
//        button.layer.shadowColor = UIColor.black.cgColor
//        button.layer.shadowOffset = CGSize(width: 0, height: 2)
//        button.layer.shadowRadius = 4
//        button.layer.shadowOpacity = 0.2
//
//        let plusConfig = UIImage.SymbolConfiguration(pointSize: 24, weight: .medium)
//        button.setImage(UIImage(systemName: "plus", withConfiguration: plusConfig), for: .normal)
//
//        button.addTarget(self, action: #selector(addButtonTapped), for: .touchUpInside)
//        return button
//    }()
//
//    private lazy var loadingIndicator: UIActivityIndicatorView = {
//        let indicator = UIActivityIndicatorView(style: .large)
//        indicator.hidesWhenStopped = true
//        indicator.translatesAutoresizingMaskIntoConstraints = false
//        return indicator
//    }()
//
//    override func viewDidLoad() {
//        super.viewDidLoad()
//
//        view.backgroundColor = DefaultAppearance.shared.screenBgColor
//        setupNavigationBar()
//
//        setupViews()
//        
//        
//        B24PaymentSdkHelper.getCurrentLanguage(language: "en")
//
//        fetchPaymentMethods()
//
//        paymentMethodsCollectionView.delegate = self
//
//    }
//
//    private func setupNavigationBar() {
//        // Create a custom title label
//        let titleLabel = UILabel()
//        titleLabel.text = B24PaymentSdkHelper
//            .localized(PaymentMethodWalletLocalizedKeys.payment_method_title.rawValue)
//        titleLabel.font = UIFont.systemFont(ofSize: 18, weight: .medium)
//        titleLabel.textColor = DefaultAppearance.shared.secondaryLabelColor
//        titleLabel.sizeToFit()
//        titleLabel.textAlignment = .left
//
//        // Set the custom title as the navigation item's titleView
//        navigationItem.titleView = titleLabel
//
//        // Configure the back button
//        navigationItem.leftBarButtonItem = UIBarButtonItem(
//            image: UIImage(systemName: "chevron.left"),
//            style: .plain,
//            target: self,
//            action: #selector(backButtonTapped)
//        )
//
//        // Optional: Customize navigation bar appearance
//        navigationController?.navigationBar.tintColor = DefaultAppearance.shared.secondaryLabelColor
//        navigationController?.navigationBar.barTintColor = DefaultAppearance.shared.screenBgColor
//    }
//
//
//    private func setupViews() {
//        view.addSubview(paymentMethodsCollectionView)
//        view.addSubview(addButton)
//        view.addSubview(loadingIndicator)
//
//        paymentMethodsCollectionView.delegate = self
//        paymentMethodsCollectionView.dataSource = self
//
//        NSLayoutConstraint.activate([
//               // Collection view constraints - now anchored to safe area
//               paymentMethodsCollectionView.topAnchor.constraint(equalTo: view.safeAreaLayoutGuide.topAnchor),
//               paymentMethodsCollectionView.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
//               paymentMethodsCollectionView.trailingAnchor.constraint(equalTo: view.trailingAnchor, constant: -16),
//               paymentMethodsCollectionView.bottomAnchor.constraint(equalTo: view.bottomAnchor),
//
//               // Add button constraints
//               addButton.widthAnchor.constraint(equalToConstant: 56),
//               addButton.heightAnchor.constraint(equalToConstant: 56),
//               addButton.trailingAnchor.constraint(equalTo: view.trailingAnchor, constant: -20),
//               addButton.bottomAnchor.constraint(equalTo: view.safeAreaLayoutGuide.bottomAnchor, constant: -20),
//
//               // Loading indicator constraints
//               loadingIndicator.centerXAnchor.constraint(equalTo: view.centerXAnchor),
//               loadingIndicator.centerYAnchor.constraint(equalTo: view.centerYAnchor)
//           ])
//    }
//
//    private func fetchPaymentMethods() {
//        isLoading = true
//        loadingIndicator.startAnimating()
//        paymentMethodsCollectionView.isHidden = true
//
//        let url = APIManager.merchantApiUrl().appendingPathComponent("instantpaymentsdk/instant_payment_methods")
//        let parameters: [String: Any] = [
//            "customer_sync_code": "C001",
//            "filter_by_status": "active"
//        ]
//
//        AF.request(
//            url,
//            method: .post,
//            parameters: parameters,
//            encoding: JSONEncoding.default,
//            headers: APIManager.initHeader()
//        ).responseData { [weak self] response in
//            guard let self = self else { return }
//
//            self.isLoading = false
//            self.loadingIndicator.stopAnimating()
//            self.paymentMethodsCollectionView.isHidden = false
//
//            switch response.result {
//            case .success(let data):
//                do {
//                    let decoder = JSONDecoder()
//                    let apiResponse = try decoder.decode(ApiResponse<InstantPaymentMethodsResponse>.self, from: data)
//
//                    if apiResponse.code == "SUCCESS" {
//                        self.paymentMethods = apiResponse.data.paymentMethods!
//                            .sorted { $0.isActive && !$1.isActive }
//                        self.paymentMethodsCollectionView.reloadData()
//                    } else {
//                        self.showError(message: apiResponse.message)
//                    }
//                } catch {
//                    self.showError(message: "Failed to process server response.")
//                }
//            case .failure(let error):
//                self.showError(message: "Network error: \(error.localizedDescription)")
//            }
//        }
//    }
//
//    private func showError(message: String) {
//        let alert = UIAlertController(title: "Error", message: message, preferredStyle: .alert)
//        alert.addAction(UIAlertAction(title: "OK", style: .default))
//        present(alert, animated: true)
//    }
//
//    @objc private func backButtonTapped() {
//        dismiss(animated: true, completion: nil)
//    }
//
//    @objc private func addButtonTapped() {
//       // print("Add wallet tapped")
//
//        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
//            if let availablePMVC = storyboard.instantiateViewController(withIdentifier: "AvailablePaymentMethodView") as? AvailablePaymentMethodView {
//                // Directly customize the navigation bar
//                    
//                availablePMVC.title = B24PaymentSdkHelper.localized(AddWalletLocalizedKeys.title.rawValue)
//                    let backButton = UIBarButtonItem()
//                    backButton.title = " "
//                    navigationController?.navigationBar.topItem?.backBarButtonItem = backButton
//
//                    navigationController?.navigationBar.tintColor = .blue
//                    navigationController?.navigationBar.barTintColor = .blue
//                    navigationController?.navigationBar.titleTextAttributes = [
//                        .foregroundColor: UIColor.blue,
//                        .font: FontManager.shared.boldFont(forLanguage: "km", size: FixFontSize.toolbarTitle)
//                    ]
//                    
//                //self.present(availablePMVC, animated: true, completion: nil)
//                navigationController?.pushViewController(availablePMVC, animated: true)
//            } else {
//                print("AddWalletView not found in storyboard")
//            }
//    }
//}
//
//extension InstantPaymentMethodViewController: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
//    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
//        return paymentMethods.count
//    }
//
////    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
////           let selectedMethod = paymentMethods[indexPath.item]
////
////        let detailViewController = InstantPaymentMethodDetailViewController(paymentMethod: selectedMethod)
////           detailViewController.modalPresentationStyle = .fullScreen
////           present(detailViewController, animated: true)
////       }
//
//
//    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
//        let method = paymentMethods[indexPath.item]
//
//        if method.isActive {
//            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "PaymentMethodCell", for: indexPath) as! PaymentMethodCell
//            cell.configure(with: method)
//            return cell
//        } else {
//            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "InactivePaymentMethodCell", for: indexPath) as! InactivePaymentMethodCell
//            cell.configure(with: method)
//            return cell
//        }
//    }
//
//    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
//        return CGSize(width: collectionView.bounds.width, height: 80)
//    }
//
//
////    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
////        let selectedMethod = paymentMethods[indexPath.row]
////
////        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
////        if let accountDetailVC = storyboard.instantiateViewController(withIdentifier: "AccountDetailView") as? AccountDetailView {
////            // Pass the selected payment method's ID
////            accountDetailVC.accountId = selectedMethod.id
////            navigationController?.pushViewController(accountDetailVC, animated: true)
////        }
////    }
//
//    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
//        let selectedMethod = paymentMethods[indexPath.row]
//
//        // Show loading indicator
//        isLoading = true
//        loadingIndicator.startAnimating()
//
//        // Fetch account detail
//        let url = APIManager.merchantApiUrl().appendingPathComponent("instantpaymentsdk/payment_method/detail")
//        let parameters: [String: Any] = ["id": selectedMethod.id]
//
//        AF.request(
//            url,
//            method: .post,
//            parameters: parameters,
//            encoding: JSONEncoding.default,
//            headers: APIManager.initHeader()
//        )
//        .validate()
//        .responseDecodable(of: ApiResponse<DataAccountDetail>.self) { [weak self] response in
//            guard let self = self else { return }
//            self.isLoading = false
//            self.loadingIndicator.stopAnimating()
//
//            switch response.result {
//            case .success(let apiResponse):
//                if apiResponse.code == "SUCCESS" {
//                    DispatchQueue.main.async {
//                        self.navigateToAccountDetail(with: apiResponse.data)
//                    }
//                } else {
//                    self.showError(message: apiResponse.message)
//                }
//            case .failure(let error):
//                self.showError(message: "Network error: \(error.localizedDescription)")
//            }
//        }
//    }
//
//
//    private func navigateToAccountDetail(with data: DataAccountDetail) {
//        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
//        if let accountDetailVC = storyboard.instantiateViewController(withIdentifier: "AccountDetailView") as? AccountDetailView {
//            accountDetailVC.dataAccountDetail = data // Pass the fetched data
//            accountDetailVC.accountId = data.id      // Optional: Pass accountId if needed
//            navigationController?.pushViewController(accountDetailVC, animated: true)
//        }
//    }
//}
//
//class PaymentMethodCell: UICollectionViewCell {
//    private let containerView: UIView = {
//           let view = UIView()
//           view.backgroundColor = DefaultAppearance.shared.onPrimaryColor
//           view.layer.cornerRadius = 16
//           view.layer.shadowColor = UIColor.black.cgColor
//           view.layer.shadowOffset = CGSize(width: 0, height: 1)
//           view.layer.shadowRadius = 4
//           view.layer.shadowOpacity = 0.05
//           view.layer.masksToBounds = false
//           view.translatesAutoresizingMaskIntoConstraints = false
//           return view
//       }()
//
//    private let walletContainerView: UIView = {
//         let view = UIView()
//         view.backgroundColor = DefaultAppearance.shared.primaryColor
//         view.layer.cornerRadius = 12
//         view.clipsToBounds = true // Add this to ensure the image doesn't exceed bounds
//         view.translatesAutoresizingMaskIntoConstraints = false
//         return view
//     }()
//
//    private let walletImageView: UIImageView = {
//        let imageView = UIImageView()
//        imageView.contentMode = .scaleAspectFit
//        imageView.tintColor = .white
//        imageView.clipsToBounds = true
//        imageView.translatesAutoresizingMaskIntoConstraints = false
//        return imageView
//    }()
//
//    private let titleLabel: UILabel = {
//        let label = UILabel()
//        label.font = .systemFont(ofSize: 18,weight: .semibold)
//        label.textColor = DefaultAppearance.shared.secondaryLabelColor
//        label.translatesAutoresizingMaskIntoConstraints = false
//        return label
//    }()
//
//    private let balanceLabel: UILabel = {
//        let label = UILabel()
//        label.font = .systemFont(ofSize: 14)
//        label.textColor = DefaultAppearance.shared.secondaryLabelColor
//        label.translatesAutoresizingMaskIntoConstraints = false
//        return label
//    }()
//
//    private let favoriteImageView: UIImageView = {
//        let imageView = UIImageView()
//        imageView.contentMode = .scaleAspectFit
//        imageView.tintColor = .systemBlue
//        imageView.translatesAutoresizingMaskIntoConstraints = false
//        imageView.image = UIImage(systemName: "star.fill")
//        return imageView
//    }()
//
//    override init(frame: CGRect) {
//        super.init(frame: frame)
//        setupCell()
//    }
//
//    required init?(coder: NSCoder) {
//        fatalError("init(coder:) has not been implemented")
//    }
//
//    private func setupCell() {
//        contentView.addSubview(containerView)
//        containerView.addSubview(walletContainerView)
//        walletContainerView.addSubview(walletImageView) // Change: Add walletImageView to walletContainerView instead
//        containerView.addSubview(titleLabel)
//        containerView.addSubview(balanceLabel)
//        containerView.addSubview(favoriteImageView)
//
//        NSLayoutConstraint.activate([
//            containerView.topAnchor.constraint(equalTo: contentView.topAnchor),
//            containerView.leadingAnchor.constraint(equalTo: contentView.leadingAnchor),
//            containerView.trailingAnchor.constraint(equalTo: contentView.trailingAnchor),
//            containerView.bottomAnchor.constraint(equalTo: contentView.bottomAnchor),
//
//            walletContainerView.leadingAnchor.constraint(equalTo: containerView.leadingAnchor, constant: 12),
//            walletContainerView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor),
//            walletContainerView.widthAnchor.constraint(equalToConstant: 48),
//            walletContainerView.heightAnchor.constraint(equalToConstant: 48),
//
//            // Change: Update walletImageView constraints to center it in walletContainerView
//            walletImageView.centerXAnchor.constraint(equalTo: walletContainerView.centerXAnchor),
//            walletImageView.centerYAnchor.constraint(equalTo: walletContainerView.centerYAnchor),
//            walletImageView.widthAnchor.constraint(equalToConstant: 30),
//            walletImageView.heightAnchor.constraint(equalToConstant: 30),
//
//            titleLabel.topAnchor.constraint(equalTo: containerView.topAnchor, constant: 12),
//            titleLabel.leadingAnchor.constraint(equalTo: walletContainerView.trailingAnchor, constant: 12),
//            titleLabel.trailingAnchor.constraint(equalTo: favoriteImageView.leadingAnchor, constant: -12),
//
//            balanceLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 4),
//            balanceLabel.leadingAnchor.constraint(equalTo: titleLabel.leadingAnchor),
//            balanceLabel.trailingAnchor.constraint(equalTo: titleLabel.trailingAnchor),
//
//            favoriteImageView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor),
//            favoriteImageView.trailingAnchor.constraint(equalTo: containerView.trailingAnchor, constant: -12),
//            favoriteImageView.widthAnchor.constraint(equalToConstant: 24),
//            favoriteImageView.heightAnchor.constraint(equalToConstant: 24)
//        ])
//    }
//
//    func configure(with method: PaymentMethodModel) {
//        titleLabel.text = method.title
//        balanceLabel.text = method.subTitle
//        favoriteImageView.isHidden = !method.isDefault
//
//        // Reset to default state first
//        //  walletImageView.image = UIImage(systemName: "wallet.pass")
//        //  walletImageView.backgroundColor = DefaultAppearance.shared.primaryColor
//
//
//
//        // Check if we have a valid logo URL
//        if !method.logo.isEmpty,
//           let logoUrl = URL(string: method.logo) {
//
//            URLSession.shared.dataTask(with: logoUrl) { [weak self] data, response, error in
//                DispatchQueue.main.async {
//                    guard let self = self,
//                          let data = data,
//                          let originalImage = UIImage(data: data),
//                          let ciImage = CIImage(image: originalImage) else {
//                        return
//                    }
//
//                    // Create color inversion filter
//                    if let colorInvertFilter = CIFilter(name: "CIColorInvert") {
//                        colorInvertFilter.setValue(ciImage, forKey: kCIInputImageKey)
//
//                        if let outputImage = colorInvertFilter.outputImage {
//                            // Create white color filter
//                            if let whiteColorFilter = CIFilter(name: "CIColorControls") {
//                                whiteColorFilter.setValue(outputImage, forKey: kCIInputImageKey)
//                                whiteColorFilter.setValue(1.0, forKey: kCIInputBrightnessKey) // Max brightness
//                                whiteColorFilter.setValue(0.0, forKey: kCIInputSaturationKey) // No saturation
//
//                                if let finalOutput = whiteColorFilter.outputImage,
//                                   let cgImage = CIContext().createCGImage(finalOutput, from: finalOutput.extent) {
//                                    let processedImage = UIImage(cgImage: cgImage)
//                                    self.walletImageView.image = processedImage
//                                }
//                            }
//                        }
//                    }
//                }
//            }.resume()
//        }else {
//            walletImageView.image = UIImage(systemName: "wallet.pass")
////            walletImageView.backgroundColor = DefaultAppearance.shared.primaryColor.withAlphaComponent(0.1)
//        }
//
//    }
//}
//
//
//class InactivePaymentMethodCell: UICollectionViewCell {
//    private let containerView: UIView = {
//        let view = UIView()
//        view.backgroundColor = DefaultAppearance.shared.onPrimaryColor
//            .withAlphaComponent(0.8) // Set opacity for the color
//        view.layer.cornerRadius = 16
//        view.layer.masksToBounds = true // Ensures content stays within rounded corners
//        view.translatesAutoresizingMaskIntoConstraints = false
//        return view
//    }()
//
//    private let walletContainerView: UIView = {
//        let view = UIView()
//        view.backgroundColor = .systemGray5 // Lighter background for icon container
//        view.layer.cornerRadius = 8
//        view.clipsToBounds = true
//        view.translatesAutoresizingMaskIntoConstraints = false
//        return view
//    }()
//
//    private let walletImageView: UIImageView = {
//        let imageView = UIImageView()
//        imageView.contentMode = .scaleAspectFit
//        imageView.tintColor = .systemGray3 // Lighter tint for inactive state
//        imageView.clipsToBounds = true
//        imageView.translatesAutoresizingMaskIntoConstraints = false
//        return imageView
//    }()
//
//    private let titleLabel: UILabel = {
//        let label = UILabel()
//        label.font = .systemFont(ofSize: 16, weight: .medium)
//        label.textColor = .systemGray2 // Lighter text color for inactive state
//        label.translatesAutoresizingMaskIntoConstraints = false
//        return label
//    }()
//
//    private let accountLabel: UILabel = {
//        let label = UILabel()
//        label.font = .systemFont(ofSize: 14)
//        label.textColor = .systemGray3
//        label.translatesAutoresizingMaskIntoConstraints = false
//        return label
//    }()
//
//    private let inactiveImageView: UIImageView = {
//        let imageView = UIImageView()
//        imageView.contentMode = .scaleAspectFit
//        imageView.tintColor = DefaultAppearance.shared.primaryLabelColor
//        imageView.image = UIImage(systemName: "slash.circle")
//        imageView.translatesAutoresizingMaskIntoConstraints = false
//        return imageView
//    }()
//
//    private let inactiveLabel: UILabel = {
//        let label = UILabel()
//        label.font = .systemFont(ofSize: 18)
//        label.textColor = DefaultAppearance.shared.primaryLabelColor
//        label.text = "This account is inactive"
//        label.translatesAutoresizingMaskIntoConstraints = false
//        return label
//    }()
//
//    override init(frame: CGRect) {
//        super.init(frame: frame)
//        setupCell()
//    }
//
//    required init?(coder: NSCoder) {
//        fatalError("init(coder:) has not been implemented")
//    }
//
//    private func setupCell() {
//        contentView.addSubview(containerView)
//        containerView.addSubview(walletContainerView)
//        walletContainerView.addSubview(walletImageView)
//        containerView.addSubview(titleLabel)
//        containerView.addSubview(accountLabel)
//        containerView.addSubview(inactiveImageView)
//        containerView.addSubview(inactiveLabel)
//
//        NSLayoutConstraint.activate([
//            // Container View
//            containerView.topAnchor.constraint(equalTo: contentView.topAnchor),
//            containerView.leadingAnchor.constraint(equalTo: contentView.leadingAnchor),
//            containerView.trailingAnchor.constraint(equalTo: contentView.trailingAnchor),
//            containerView.bottomAnchor.constraint(equalTo: contentView.bottomAnchor),
//
//            // Wallet Container
//            walletContainerView.leadingAnchor.constraint(equalTo: containerView.leadingAnchor, constant: 16),
//            walletContainerView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor),
//            walletContainerView.widthAnchor.constraint(equalToConstant: 40),
//            walletContainerView.heightAnchor.constraint(equalToConstant: 40),
//
//            // Wallet Image View
//            walletImageView.centerXAnchor.constraint(equalTo: walletContainerView.centerXAnchor),
//            walletImageView.centerYAnchor.constraint(equalTo: walletContainerView.centerYAnchor),
//            walletImageView.widthAnchor.constraint(equalToConstant: 24),
//            walletImageView.heightAnchor.constraint(equalToConstant: 24),
//
//            // Title Label
//            titleLabel.topAnchor.constraint(equalTo: containerView.topAnchor, constant: 16),
//            titleLabel.leadingAnchor.constraint(equalTo: walletContainerView.trailingAnchor, constant: 12),
//            titleLabel.trailingAnchor.constraint(equalTo: containerView.trailingAnchor, constant: -16),
//
//            // Account Label
//            accountLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 4),
//            accountLabel.leadingAnchor.constraint(equalTo: titleLabel.leadingAnchor),
//            accountLabel.trailingAnchor.constraint(equalTo: titleLabel.trailingAnchor),
//
//            // Inactive Image View
//            inactiveImageView.centerXAnchor.constraint(equalTo: containerView.centerXAnchor),
//            inactiveImageView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor, constant: -16),
////            inactiveImageView.widthAnchor.constraint(equalToConstant: 32),
////            inactiveImageView.heightAnchor.constraint(equalToConstant: 32),
//
//            // Inactive Label
//            inactiveLabel.topAnchor.constraint(equalTo: inactiveImageView.bottomAnchor, constant: 4),
//            inactiveLabel.centerXAnchor.constraint(equalTo: containerView.centerXAnchor),
//            inactiveLabel.leadingAnchor.constraint(greaterThanOrEqualTo: containerView.leadingAnchor, constant: 32),
//            inactiveLabel.trailingAnchor.constraint(lessThanOrEqualTo: containerView.trailingAnchor, constant: -32)
//        ])
//    }
//
//    func configure(with method: PaymentMethodModel) {
//        titleLabel.text = method.title
//        accountLabel.text = method.subTitle
//
//        if let logoUrl = URL(string: method.logo), !method.logo.isEmpty {
//            URLSession.shared.dataTask(with: logoUrl) { [weak self] data, _, _ in
//                guard let self = self, let data = data, let originalImage = UIImage(data: data) else { return }
//
//                DispatchQueue.main.async {
//                    self.walletImageView.image = self.processedImage(from: originalImage)
//                }
//            }.resume()
//        } else {
//            walletImageView.image = UIImage(systemName: "wallet.pass")
//        }
//    }
//
//    private func processedImage(from image: UIImage) -> UIImage? {
//        guard let ciImage = CIImage(image: image) else { return nil }
//
//        // Apply color inversion filter
//        if let colorInvertFilter = CIFilter(name: "CIColorInvert") {
//            colorInvertFilter.setValue(ciImage, forKey: kCIInputImageKey)
//            if let invertedImage = colorInvertFilter.outputImage {
//
//                // Apply white color filter
//                if let whiteColorFilter = CIFilter(name: "CIColorControls") {
//                    whiteColorFilter.setValue(invertedImage, forKey: kCIInputImageKey)
//                    whiteColorFilter.setValue(1.0, forKey: kCIInputBrightnessKey)
//                    whiteColorFilter.setValue(0.0, forKey: kCIInputSaturationKey)
//
//                    if let outputImage = whiteColorFilter.outputImage,
//                       let cgImage = CIContext().createCGImage(outputImage, from: outputImage.extent) {
//                        return UIImage(cgImage: cgImage)
//                    }
//                }
//            }
//        }
//        return nil
//    }
//}
//
//
//
////
////class InactivePaymentMethodCell: UICollectionViewCell {
////    private let containerView: UIView = {
////        let view = UIView()
////        view.backgroundColor = .systemGray5
////        view.layer.cornerRadius = 16
////        view.layer.shadowColor = UIColor.black.cgColor
////        view.layer.shadowOffset = CGSize(width: 0, height: 1)
////        view.layer.shadowRadius = 4
////        view.layer.shadowOpacity = 0.05
////        view.layer.masksToBounds = false
////        view.translatesAutoresizingMaskIntoConstraints = false
////        return view
////    }()
////
////    private let walletContainerView: UIView = {
////        let view = UIView()
////        view.backgroundColor = .systemGray4
////        view.layer.cornerRadius = 12
////        view.clipsToBounds = true
////        view.translatesAutoresizingMaskIntoConstraints = false
////        return view
////    }()
////
////    private let walletImageView: UIImageView = {
////        let imageView = UIImageView()
////        imageView.contentMode = .scaleAspectFit
////        imageView.tintColor = .white
////        imageView.clipsToBounds = true
////        imageView.translatesAutoresizingMaskIntoConstraints = false
////        return imageView
////    }()
////
////    private let titleLabel: UILabel = {
////        let label = UILabel()
////        label.font = .systemFont(ofSize: 18, weight: .semibold)
////        label.textColor = .systemGray
////        label.translatesAutoresizingMaskIntoConstraints = false
////        return label
////    }()
////
////    private let inactiveLabel: UILabel = {
////        let label = UILabel()
////        label.font = .systemFont(ofSize: 14)
////        label.textColor = .systemBlue
////        label.text = "This account is inactive"
////        label.translatesAutoresizingMaskIntoConstraints = false
////        return label
////    }()
////
////    private let banImageView: UIImageView = {
////        let imageView = UIImageView()
////        imageView.contentMode = .scaleAspectFit
////        imageView.tintColor = .systemBlue
////        imageView.translatesAutoresizingMaskIntoConstraints = false
////        imageView.image = UIImage(systemName: "slash.circle")
////        return imageView
////    }()
////
////    override init(frame: CGRect) {
////        super.init(frame: frame)
////        setupCell()
////    }
////
////    required init?(coder: NSCoder) {
////        fatalError("init(coder:) has not been implemented")
////    }
////
////    private func setupCell() {
////        contentView.addSubview(containerView)
////        containerView.addSubview(walletContainerView)
////        walletContainerView.addSubview(walletImageView)
////        containerView.addSubview(titleLabel)
////        containerView.addSubview(inactiveLabel)
////        containerView.addSubview(banImageView)
////
////        NSLayoutConstraint.activate([
////            containerView.topAnchor.constraint(equalTo: contentView.topAnchor),
////            containerView.leadingAnchor.constraint(equalTo: contentView.leadingAnchor),
////            containerView.trailingAnchor.constraint(equalTo: contentView.trailingAnchor),
////            containerView.bottomAnchor.constraint(equalTo: contentView.bottomAnchor),
////
////            walletContainerView.leadingAnchor.constraint(equalTo: containerView.leadingAnchor, constant: 12),
////            walletContainerView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor),
////            walletContainerView.widthAnchor.constraint(equalToConstant: 48),
////            walletContainerView.heightAnchor.constraint(equalToConstant: 48),
////
////            walletImageView.centerXAnchor.constraint(equalTo: walletContainerView.centerXAnchor),
////            walletImageView.centerYAnchor.constraint(equalTo: walletContainerView.centerYAnchor),
////            walletImageView.widthAnchor.constraint(equalToConstant: 30),
////            walletImageView.heightAnchor.constraint(equalToConstant: 30),
////
////            titleLabel.topAnchor.constraint(equalTo: containerView.topAnchor, constant: 12),
////            titleLabel.leadingAnchor.constraint(equalTo: walletContainerView.trailingAnchor, constant: 12),
////            titleLabel.trailingAnchor.constraint(equalTo: banImageView.leadingAnchor, constant: -12),
////
////            inactiveLabel.topAnchor.constraint(equalTo: titleLabel.bottomAnchor, constant: 4),
////            inactiveLabel.leadingAnchor.constraint(equalTo: titleLabel.leadingAnchor),
////            inactiveLabel.trailingAnchor.constraint(equalTo: titleLabel.trailingAnchor),
////
////            banImageView.centerYAnchor.constraint(equalTo: containerView.centerYAnchor),
////            banImageView.trailingAnchor.constraint(equalTo: containerView.trailingAnchor, constant: -12),
////            banImageView.widthAnchor.constraint(equalToConstant: 24),
////            banImageView.heightAnchor.constraint(equalToConstant: 24)
////        ])
////    }
////
////    func configure(with method: PaymentMethodModel) {
////        titleLabel.text = method.title
////
////        if !method.logo.isEmpty, let logoUrl = URL(string: method.logo) {
////            URLSession.shared.dataTask(with: logoUrl) { [weak self] data, response, error in
////                DispatchQueue.main.async {
////                    guard let self = self,
////                          let data = data,
////                          let originalImage = UIImage(data: data),
////                          let ciImage = CIImage(image: originalImage) else {
////                        return
////                    }
////
////                    // Create color inversion filter
////                    if let colorInvertFilter = CIFilter(name: "CIColorInvert") {
////                        colorInvertFilter.setValue(ciImage, forKey: kCIInputImageKey)
////
////                        if let outputImage = colorInvertFilter.outputImage {
////                            // Create white color filter
////                            if let whiteColorFilter = CIFilter(name: "CIColorControls") {
////                                whiteColorFilter.setValue(outputImage, forKey: kCIInputImageKey)
////                                whiteColorFilter.setValue(1.0, forKey: kCIInputBrightnessKey)
////                                whiteColorFilter.setValue(0.0, forKey: kCIInputSaturationKey)
////
////                                if let finalOutput = whiteColorFilter.outputImage,
////                                   let cgImage = CIContext().createCGImage(finalOutput, from: finalOutput.extent) {
////                                    let processedImage = UIImage(cgImage: cgImage)
////                                    self.walletImageView.image = processedImage
////                                }
////                            }
////                        }
////                    }
////                }
////            }.resume()
////        } else {
////            walletImageView.image = UIImage(systemName: "wallet.pass")
////        }
////    }
////}
//
