//
//  LoadingView.swift
//  B24PaymentSdk
//
//  Created by visal ny on 23/12/24.
//

import UIKit

class LoadingView: UIViewController {

    @IBOutlet weak var loadingIndicator: UIActivityIndicatorView!
    @IBOutlet weak var loadingContainer: UIView!
    override func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = UIColor.black.withAlphaComponent(0.1)

        setUpView()

    }

    func setUpView(){
//        loadingContainer.backgroundColor = DefaultAppearance.shared.cardColor
        loadingContainer.backgroundColor = .clear
        loadingContainer.layer.cornerRadius = 8
        loadingIndicator.style =  .large
        loadingIndicator.color = DefaultAppearance.shared.primaryColor
        loadingIndicator.startAnimating()
    }

    static func show(in parentViewController: UIViewController) -> LoadingView {
        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
            let loadingView = storyboard.instantiateViewController(withIdentifier: "LoadingView") as! LoadingView
            loadingView.modalPresentationStyle = .overCurrentContext
            loadingView.modalTransitionStyle = .crossDissolve
            parentViewController.present(loadingView, animated: true, completion: nil)
            return loadingView
        }

    func dismiss(completion: (() -> Void)? = nil) {
        DispatchQueue.main.async {
            self.dismiss(animated: true) {
                completion?()
            }
        }
    }

}




