//
//  WarningAlertView.swift
//  B24PaymentSdk
//
//  Created by visal ny on 23/12/24.
//

import UIKit

class WarningAlertView: UIViewController {

    @IBOutlet weak var container: UIView!
    @IBOutlet weak var alertContainer: UIView!
    @IBOutlet weak var warningIcon: UIImageView!
    
    @IBOutlet weak var warningFirstTitle: UILabel!
    
    @IBOutlet weak var buttonOk: UIButton!
    @IBOutlet weak var buttonCancel: UIButton!
    @IBOutlet weak var warningSecondTitle: UILabel!
    
    var okActionHandler: (() -> Void)?
    var cancelActionHandler: (() -> Void)?
    
    var language:String?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = UIColor.black.withAlphaComponent(0.5)
        
        getSharePref()
        
        B24PaymentSdkHelper.getCurrentLanguage(language: language)
        
        setupView()
        
    }
    
    func getSharePref(){
        if let languageCode = SharedPreferenceManager.getString(forKey: SharePrefKey.lanuageCode.rawValue){
            language = languageCode
        }else{
            language = "km"
        }
    }
    
    
    func setupView() {
        container.backgroundColor =  DefaultAppearance.shared.cardColor
        container.layer.cornerRadius = 12
        alertContainer.layer.masksToBounds = true
        
        warningIcon.tintColor =  DefaultAppearance.shared.warningColor
        buttonOk.tintColor = DefaultAppearance.shared.primaryColor
       
//        buttonCancel.tintColor = DefaultAppearance.shared.primaryLabelColor
        
//        warningFirstTitle.font = FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText)
        warningSecondTitle.font = FontManager.shared.mediumFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        warningFirstTitle.textColor = DefaultAppearance.shared.primaryLabelColor
        warningSecondTitle.textColor = DefaultAppearance.shared.primaryLabelColor

        
//        let okTitle = NSAttributedString(
//            string : B24PaymentSdkHelper.localized(DialogLocalizedKeys.ok.rawValue),
//            attributes: [
//                .font: FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText),
//                .foregroundColor: DefaultAppearance.shared.onPrimaryColor,
//                .backgroundColor: DefaultAppearance.shared.primaryColor
//            ]
//        )
//        buttonOk.setAttributedTitle(okTitle, for: .normal)
//        
//        
//        
//        let cancelTitle = NSAttributedString(
//            string : B24PaymentSdkHelper.localized(DialogLocalizedKeys.cancel.rawValue),
//            attributes: [
//                .font: FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText),
//                .foregroundColor: DefaultAppearance.shared.primaryLabelColor
//            ]
//        )
//        buttonCancel.setAttributedTitle(cancelTitle, for: .normal)
        
    }
    
    func configure(
            firstTitle: String,
            secondTitle: String,
            okButtonTitle: String,
            cancelButtonTitle: String,
            okHandler: @escaping () -> Void,
            cancelHandler: @escaping () -> Void
        ) {
            
            DispatchQueue.main.async {
                
//                if let firstTitleLabel = self.warningFirstTitle {
//                    firstTitleLabel.text = firstTitle
//                }
//                if let secondTitleLabel = self.warningSecondTitle {
//                    secondTitleLabel.text = secondTitle
//                }
//                if let okButton = self.buttonOk {
//                    
//                    okButton.setTitle(okButtonTitle, for: .normal)
//                }
//                if let cancelButton = self.buttonCancel {
//                    cancelButton.setTitle(cancelButtonTitle, for: .normal)
//                }
//                
//                self.okActionHandler = okHandler
//                self.cancelActionHandler = cancelHandler
                
                DispatchQueue.main.async {
                        // Update first and second titles dynamically
                        //self.warningFirstTitle.text = firstTitle
                        self.warningSecondTitle.text = secondTitle
                    
                    
                    let paragraphStyle = NSMutableParagraphStyle()
                    paragraphStyle.minimumLineHeight = 23
                    paragraphStyle.maximumLineHeight = 23
                    paragraphStyle.alignment = .center

                    let attributedString = NSAttributedString(
                        string: firstTitle,
                        attributes: [
                            .paragraphStyle: paragraphStyle,
                            .font: FontManager.shared.regularFont(forLanguage: self.language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText),
                            .foregroundColor: DefaultAppearance.shared.primaryLabelColor
                        ]
                    )

                    self.warningFirstTitle.attributedText = attributedString
                    
                    
                    

                    // Set dynamic titles with font and color for buttons
                            let okAttributedTitle = NSAttributedString(
                                string: okButtonTitle,
                                attributes: [
                                    .font: FontManager.shared.regularFont(forLanguage: self.language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText),
                                    .foregroundColor: DefaultAppearance.shared.onPrimaryColor,
                                    
                                ]
                            )
                            
                            self.buttonOk.setAttributedTitle(okAttributedTitle, for: .normal)

                            let cancelAttributedTitle = NSAttributedString(
                                string: cancelButtonTitle,
                                attributes: [
                                    .font: FontManager.shared.regularFont(forLanguage: self.language ?? "km", fontFromconfig: DefaultAppearance.shared.fontEnglish,size: FixFontSize.contentText),
                                    .foregroundColor: DefaultAppearance.shared.primaryLabelColor
                                ]
                            )
                            self.buttonCancel.setAttributedTitle(cancelAttributedTitle, for: .normal)
                        // Set the action handlers
                        self.okActionHandler = okHandler
                        self.cancelActionHandler = cancelHandler
                    }
            }
        }
    
    @IBAction func cancelAction(_ sender: Any) {
        dismiss(animated: true) {
          self.cancelActionHandler?()
        }
    }
    
    @IBAction func okAction(_ sender: Any) {
        dismiss(animated: true) {
            self.okActionHandler?()
        }
    }
    
    
    func showWarningAlert(from presentingViewController: UIViewController, okHandler: @escaping () -> Void, cancelHandler: @escaping () -> Void) {
        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
            guard let alertView = storyboard.instantiateViewController(withIdentifier: "WarningAlertView") as? WarningAlertView else {
                return
            }

            alertView.modalPresentationStyle = .overFullScreen
            alertView.modalTransitionStyle = .crossDissolve

            alertView.configure(
        
                firstTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.waring_first.rawValue),
                secondTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.warning_two.rawValue),
                okButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.ok.rawValue),
                cancelButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.cancel.rawValue),
                okHandler: okHandler,
                cancelHandler: cancelHandler
            )

            // Present the alert from the calling view controller
            presentingViewController.present(alertView, animated: true)
        }
   
    func showWarningTopupAlert(from presentingViewController: UIViewController, okHandler: @escaping () -> Void, cancelHandler: @escaping () -> Void) {
        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
            guard let alertView = storyboard.instantiateViewController(withIdentifier: "WarningAlertView") as? WarningAlertView else {
                return
            }

            alertView.modalPresentationStyle = .overFullScreen
            alertView.modalTransitionStyle = .crossDissolve

            alertView.configure(
        
                firstTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.topup_waning.rawValue),
                secondTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.warning_two.rawValue),
                okButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.active.rawValue),
                cancelButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.cancel.rawValue),
                okHandler: okHandler,
                cancelHandler: cancelHandler
            )

            // Present the alert from the calling view controller
            presentingViewController.present(alertView, animated: true)
        }
}
