//
//  SharePreferenceManager.swift
//  B24PaymentSdk
//
//  Created by visal ny on 25/12/24.
//

import Foundation

class SharedPreferenceManager {

    // Method to set a value
    static func set(value: Any, forKey key: String) {
        UserDefaults.standard.set(value, forKey: key)
        
    }
    
    // Method to get a value
    static func get(forKey key: String) -> Any? {
        return UserDefaults.standard.object(forKey: key)
    }
    
    // Method to get a String value
    static func getString(forKey key: String) -> String? {
        return UserDefaults.standard.string(forKey: key)
    }
    
    // Method to get an Integer value
    static func getInt(forKey key: String) -> Int {
        return UserDefaults.standard.integer(forKey: key)
    }
    
    // Method to get a Boolean value
    static func getBool(forKey key: String) -> Bool {
        return UserDefaults.standard.bool(forKey: key)
    }
    
    // Method to set a custom object
        static func setModel<T: Codable>(value: T, forKey key: String) {
            let encoder = JSONEncoder()
            if let encoded = try? encoder.encode(value) {
                UserDefaults.standard.set(encoded, forKey: key)
            }
        }
        
        // Method to get a custom object
        static func getModel<T: Codable>(forKey key: String, type: T.Type) -> T? {
            if let data = UserDefaults.standard.data(forKey: key) {
                let decoder = JSONDecoder()
                if let decoded = try? decoder.decode(T.self, from: data) {
                    return decoded
                }
            }
            return nil
        }
    
    // Method to remove a value
    static func remove(forKey key: String) {
        UserDefaults.standard.removeObject(forKey: key)
    }
    
    
//    SharedPreferenceManager.set(value: user, forKey: "currentUser")
//
//    // Retrieving the user object
//    if let retrievedUser: User = SharedPreferenceManager.get(forKey: "currentUser", type: User.self) {
//        print("Username: \(retrievedUser.username), Age: \(retrievedUser.age)")
//    } else {
//        print("No user found in UserDefaults")
//    }
}
