//
//  FontManager.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 2/11/23.
//

import Foundation
import UIKit

public class FontManager {
    public static let shared = FontManager()

    private init() {}

    public func regularFont(forLanguage language: String,fontFromconfig:String?=nil, size: CGFloat) -> UIFont {
        var fontName: String
        switch language {
        case "en":
            if fontFromconfig == "Poppins"{
                fontName = "Poppins-Regular"
            }else{
                fontName = "Roboto-Regular"
            }
            
        case "km":
            fontName = "Battambang-Regular"
        default:
            fontName = "Battambang-Regular"
        }

        if let customFont = B24PaymentSdkHelper.setFont(named: fontName, ofSize: size) {
            return customFont
        } else {
            return UIFont.systemFont(ofSize: size) // Fallback to system font if the custom font
        }
    }
    
    public func mediumFont(forLanguage language: String,fontFromconfig:String?=nil, size: CGFloat) -> UIFont {
        var fontName: String
        switch language {
        case "en":
            if fontFromconfig == "Poppins"{
                fontName = "Poppins-Medium"
            }else{
                fontName = "Roboto-Medium"
            }
        case "km":
//            fontName = "battambang-900"
            fontName = "battambang-bold"
        default:
            fontName = "battambang-bold"
        }

        if let customFont = B24PaymentSdkHelper.setFont(named: fontName, ofSize: size) {
            return customFont
        } else {
            return UIFont.systemFont(ofSize: size) // Fallback to system font if the custom font
        }
    }
    
    public func boldFont(forLanguage language: String,fontFromconfig:String?=nil, size: CGFloat) -> UIFont {
        var fontName: String
        switch language {
        case "en":
            if fontFromconfig == "Poppins"{
                fontName = "Poppins-bold"
            }else{
                fontName = "Roboto-Bold"
            }
           
        case "km":
            fontName = "battambang-bold"
        default:
            fontName = "battambang-bold"
        }

        if let customFont = B24PaymentSdkHelper.setFont(named: fontName, ofSize: size) {
            return customFont
        } else {
            return UIFont.systemFont(ofSize: size) // Fallback to system font if the custom font
        }
    }
}

