//
//  SDKThemes.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 31/10/23.
//

import Foundation

public struct Themes{
    public struct Property {
        static var primaryTextColor: String = ""
        static var primaryBackgroundColor: String = ""
        static var indicatorColor: String = ""
        static var secondaryTextColor: String = ""
        static var secondaryBackgroundColor: String = ""
        static var labelTextColor: String = ""
        static var labelBackgroundColor: String = ""
        static var alertTextColor: String = ""
        static var alertBackgroundColor: String = ""
        static var favoriteButtonTextColor: String = ""
        static var favoriteButtonBackgroundColor: String = ""
        static var bankButtonBackgroundColor: String = ""
        static var bankButtonTextPrimaryColor: String = ""
        static var bankButtonTextSecondaryColor: String = ""
        static var actionButtonTextColor: String = ""
        static var actionButtonBackgroundColor: String = ""
        static var buttonTextColor: String = ""
        static var buttonBackgroundColor: String = ""
    }
 
    public static func setTheme(isDarkMode: Bool, themeData: Appearance) {
        Themes.Property.primaryTextColor = isDarkMode ? themeData.darkMode.primaryColor.textColor : themeData.lightMode.primaryColor.textColor
        Themes.Property.primaryBackgroundColor = isDarkMode ? themeData.darkMode.primaryColor.backgroundColor : themeData.lightMode.primaryColor.backgroundColor
        Themes.Property.indicatorColor = isDarkMode ? themeData.darkMode.indicatorColor : themeData.lightMode.indicatorColor
        
        Themes.Property.secondaryTextColor = isDarkMode ? themeData.darkMode.secondaryColor.textColor : themeData.lightMode.secondaryColor.textColor
        Themes.Property.secondaryBackgroundColor = isDarkMode ? themeData.darkMode.secondaryColor.backgroundColor : themeData.lightMode.secondaryColor.backgroundColor
        
        Themes.Property.labelTextColor = isDarkMode ? themeData.darkMode.label.textColor : themeData.lightMode.label.textColor
        Themes.Property.labelBackgroundColor = isDarkMode ? themeData.darkMode.label.backgroundColor : themeData.lightMode.label.backgroundColor
        
        Themes.Property.alertTextColor = isDarkMode ? themeData.darkMode.alert.textColor : themeData.lightMode.alert.textColor
        Themes.Property.alertBackgroundColor = isDarkMode ? themeData.darkMode.alert.backgroundColor : themeData.lightMode.alert.backgroundColor
        
        Themes.Property.favoriteButtonTextColor = isDarkMode ? themeData.darkMode.button.favoriteButton.textColor : themeData.lightMode.button.favoriteButton.textColor
        Themes.Property.favoriteButtonBackgroundColor = isDarkMode ? themeData.darkMode.button.favoriteButton.backgroundColor : themeData.lightMode.button.favoriteButton.backgroundColor
        
        Themes.Property.bankButtonTextPrimaryColor = isDarkMode ? themeData.darkMode.button.bankButton.textPrimary : themeData.lightMode.button.bankButton.textPrimary
        Themes.Property.bankButtonTextSecondaryColor = isDarkMode ? themeData.darkMode.button.bankButton.textSecondary : themeData.lightMode.button.bankButton.textSecondary
        Themes.Property.bankButtonBackgroundColor = isDarkMode ? themeData.darkMode.button.bankButton.backgroundColor : themeData.lightMode.button.bankButton.backgroundColor
        
        Themes.Property.actionButtonTextColor = isDarkMode ? themeData.darkMode.button.actionButton.textColor : themeData.lightMode.button.actionButton.textColor
        Themes.Property.actionButtonBackgroundColor = isDarkMode ? themeData.darkMode.button.actionButton.backgroundColor : themeData.lightMode.button.actionButton.backgroundColor
        
        Themes.Property.buttonTextColor = isDarkMode ? themeData.darkMode.button.textColor : themeData.lightMode.button.textColor
        Themes.Property.buttonBackgroundColor = isDarkMode ? themeData.darkMode.button.backgroundColor : themeData.lightMode.button.backgroundColor
        
    }

}




