//
//  AvailablePMTypeResponseModel.swift
//  B24PaymentSdk
//
//  Created by visal ny on 19/12/24.
//

import Foundation

struct AvailablePMTypeResponseModel: Codable {
    let code, message, messageKh: String
    let data: DataAvailablePMType

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct DataAvailablePMType: Codable {
    let availablePaymentMethodTypes: [AvailablePaymentMethodType]

    enum CodingKeys: String, CodingKey {
        case availablePaymentMethodTypes = "available_payment_method_types"
    }
}

// MARK: - AvailablePaymentMethodType
struct AvailablePaymentMethodType: Codable {
    let type, name, nameKh: String
    let logo: String
    let isActive: Bool

    enum CodingKeys: String, CodingKey {
        case type, name
        case nameKh = "name_kh"
        case logo
        case isActive = "is_active"
    }
}
