// MARK: - Wallet Configuration
struct InstantConfigReposeModel: Codable {
    let walletAppearance: WalletAppearance

    enum CodingKeys: String, CodingKey {
        case walletAppearance = "appearance"
    }
}

struct WalletAppearance: Codable {
    let lightMode, darkMode: WalletMode

    enum CodingKeys: String, CodingKey {
        case lightMode = "light_mode"
        case darkMode = "dark_mode"
    }
}

struct WalletMode: Codable {
    let primaryColor: String
    let screenBgColor: String
    let primaryLabelColor: String
    let secondaryLabelColor: String
    let cardColor: String
    let onPrimaryColor: String
    let dangerColor: String
    let warningColor: String

    enum CodingKeys: String, CodingKey {
        case primaryColor = "primary_color"
        case screenBgColor = "screen_bg_color"
        case primaryLabelColor = "primary_label_color"
        case secondaryLabelColor = "secondary_label_color"
        case cardColor = "card_color"
        case onPrimaryColor = "on_primary_color"
        case dangerColor = "danger_color"
        case warningColor = "warning_color"
    }
}

// MARK: - Payment Methods
struct InstantPaymentMethodsResponse: Codable {
    let customerSyncCode: String?
    let customerCode: String?
    let customerName: String?
    let paymentMethods: [PaymentMethodModel]?
    let paymentMethodTypes: [PaymentMethodType]?

    enum CodingKeys: String, CodingKey {
        case customerSyncCode = "customer_sync_code"
        case customerCode = "customer_code"
        case customerName = "customer_name"
        case paymentMethods = "payment_methods"
        case paymentMethodTypes = "payment_method_types"
    }
}

struct PaymentMethodType: Codable, LocalizedContent {
    let type: String
    let name: String
    let nameKh: String

    enum CodingKeys: String, CodingKey {
        case type, name
        case nameKh = "name_kh"
    }
}

class PaymentMethodModel: BaseModel {
    let logo: String
    let title: String
    let subTitle: String
    let subTitleKh: String
    let isDefault: Bool
    let status: String
    let type: String

    enum CodingKeys: String, CodingKey {
        case id, logo, title, type
        case subTitle = "sub_title"
        case subTitleKh = "sub_title_kh"
        case isDefault = "is_default"
        case status
    }
    
   

    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.logo = try container.decode(String.self, forKey: .logo)
        self.title = try container.decode(String.self, forKey: .title)
        self.subTitle = try container.decode(String.self, forKey: .subTitle)
        self.subTitleKh = try container.decode(String.self, forKey: .subTitleKh)
        self.isDefault = try container.decode(Bool.self, forKey: .isDefault)
        self.status = try container.decode(String.self, forKey: .status)
        self.type = try container.decode(String.self, forKey: .type)
        try super.init(from: decoder)
    }
}

// MARK: - PaymentMethodModel Extensions
extension PaymentMethodModel {
    var isActive: Bool {
        return status == "active"
    }

    var balance: Double {
        guard let balanceStr = subTitle.split(separator: ":").last?.trimmingCharacters(in: .whitespaces),
              let balanceNum = balanceStr.split(separator: " ").first,
              let balance = Double(balanceNum) else {
            return 0.0
        }
        return balance
    }
}

// MARK: - Wallet
struct WalletPayload: Codable {
    let account_name: String
    let customer_sync_code: String
    let currency: String
}

struct SetDefaultPayload:Codable{
    let id:String
}

struct ModifyNamePayload:Codable{
    let id:String
    let name:String
}

struct UpdateStatus:Codable{
    let id:String
    let inactive:Bool
}

struct TopUp:Codable{
    let id:String
    let amount:Decimal
}

struct TopUpResponseModel:Codable{
    let tranId: String
        let identityCode: String
        let paymentLink: String
        let khqrString: String
        
        enum CodingKeys: String, CodingKey {
            case tranId = "tran_id"
            case identityCode = "identity_code"
            case paymentLink = "payment_link"
            case khqrString = "khqr_string"
        }
}

struct WalletResponseData: Codable {
    let encrypted: String?
}
