//
//  Transaction.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 17/10/23.
//

import Foundation

var bankPaymentMethods : [BankPaymentMethod] = []

// MARK: - Transaction
struct Transaction: Codable {
    var code, message, messageKh: String?
    var data: DataClass?

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct DataClass: Codable {
    var biller: Biller
    var transInfo: TransInfo
    var checkoutPageConfig: CheckoutPageConfig

    enum CodingKeys: String, CodingKey {
        case biller
        case transInfo = "trans_info"
        case checkoutPageConfig = "checkout_page_config"
    }
}

// MARK: - Biller
struct Biller: Codable {
    var billerCode, billerName, billerNameKh, billerDisplayName: String
    var billerLogo: String?

    enum CodingKeys: String, CodingKey {
        case billerCode = "biller_code"
        case billerName = "biller_name"
        case billerNameKh = "biller_name_kh"
        case billerDisplayName = "biller_display_name"
        case billerLogo = "biller_logo"
    }
}

// MARK: - CheckoutPageConfig
struct CheckoutPageConfig: Codable {
    var logo: String
    var backgroundImage: String
    var displayBill24Info,displaySuccessPage: Bool
    var favicon: Favicon
    var setting: Setting
    var appearance: Appearance

    enum CodingKeys: String, CodingKey {
        case logo
        case backgroundImage = "background_image"
        case displaySuccessPage = "display_success_page"
        case displayBill24Info = "display_bill24_info"
        case favicon, setting, appearance
    }
}

// MARK: - Appearance
public struct Appearance: Codable {
    var lightMode, darkMode: Mode

    enum CodingKeys: String, CodingKey {
        case lightMode = "light_mode"
        case darkMode = "dark_mode"
    }
}

// MARK: - Mode
struct Mode: Codable {
    let primaryColor: Alert
    let indicatorColor: String
    let secondaryColor, label, alert: Alert
    let button: Button

    enum CodingKeys: String, CodingKey {
        case primaryColor = "primary_color"
        case indicatorColor = "indicator_color"
        case secondaryColor = "secondary_color"
        case label, alert, button
    }
}

// MARK: - Alert
struct Alert: Codable {
    let textColor, backgroundColor: String

    enum CodingKeys: String, CodingKey {
        case textColor = "text_color"
        case backgroundColor = "background_color"
    }
}

// MARK: - Button
struct Button: Codable {
    let favoriteButton: Alert
    let bankButton: BankButton
    let actionButton: Alert
    let textColor, backgroundColor: String

    enum CodingKeys: String, CodingKey {
        case favoriteButton = "favorite_button"
        case bankButton = "bank_button"
        case actionButton = "action_button"
        case textColor = "text_color"
        case backgroundColor = "background_color"
    }
}

// MARK: - BankButton
struct BankButton: Codable {
    let backgroundColor, textPrimary, textSecondary: String

    enum CodingKeys: String, CodingKey {
        case backgroundColor = "background_color"
        case textPrimary = "text_primary"
        case textSecondary = "text_secondary"
    }
}

// MARK: - Favicon
struct Favicon: Codable {
    var icon16X16, icon32X32, icon96X96: String

    enum CodingKeys: String, CodingKey {
        case icon16X16 = "icon_16x16"
        case icon32X32 = "icon_32x32"
        case icon96X96 = "icon_96x96"
    }
}

// MARK: - Setting
struct Setting: Codable {
    var displayFee: Bool

    enum CodingKeys: String, CodingKey {
        case displayFee = "display_fee"
    }
}

// MARK: - TransInfo
struct TransInfo: Codable {
    var tranID, identityCode, tranNo: String
    var tranAmount: Double
    var tranAmountDisplay: String
    var totalAmount: Double
    var totalAmountDisplay, currency: String
    var feeAmount: Double
    var feeAmountDisplay: String
    var isAllowFavorite: Bool
    var customerCode, customerName, customerEmail, customerPhone, paymentLink,bankRefID: String?
    var tranDate, expiredDate, status: String
    var cancelURL, redirectURL: String
    var language: String
    var khqrImage: String?
    var khqrString, description: String
    var bankPaymentMethod: [BankPaymentMethod]

    enum CodingKeys: String, CodingKey {
        case tranID = "tran_id"
        case identityCode = "identity_code"
        case tranNo = "tran_no"
        case tranAmount = "tran_amount"
        case tranAmountDisplay = "tran_amount_display"
        case totalAmount = "total_amount"
        case totalAmountDisplay = "total_amount_display"
        case feeAmount = "fee_amount"
        case feeAmountDisplay = "fee_amount_display"
        case currency
        case isAllowFavorite = "is_allow_favorite"
        case customerCode = "customer_code"
        case customerName = "customer_name"
        case customerEmail = "customer_email"
        case customerPhone = "customer_phone"
        case tranDate = "tran_date"
        case expiredDate = "expired_date"
        case bankRefID = "bank_ref_id"
        case status
        case cancelURL = "cancel_url"
        case redirectURL = "redirect_url"
        case paymentLink = "payment_link"
        case language
        case khqrImage = "khqr_image"
        case khqrString = "khqr_string"
        case description
        case bankPaymentMethod = "bank_payment_method"
    }
}

// MARK: - BankPaymentMethod
struct BankPaymentMethod: Codable {
    var section, sectionKh: String
    var items: [BankPaymentItem]

    enum CodingKeys: String, CodingKey {
        case section
        case sectionKh = "section_kh"
        case items
    }
}

// MARK: - Item
struct BankPaymentItem: Codable {
    var name, nameKh: String?
    var id: String
    var logo: String
    var isFavorite: Bool?
    var fee: Double
    var feeDisplay: String
    var supportDeeplink, supportCheckoutPage: Bool

    enum CodingKeys: String, CodingKey {
        case id, name
        case nameKh = "name_kh"
        case logo
        case isFavorite = "is_favorite"
        case fee
        case feeDisplay = "fee_display"
        case supportDeeplink = "support_deeplink"
        case supportCheckoutPage = "support_checkout_page"
    }
}
