//
//  TopUpView.swift
//  B24PaymentSdk
//
//  Created by visal ny on 25/12/24.
//

import UIKit
import Alamofire

class TopUpView: UIViewController,UICollectionViewDelegate,UICollectionViewDataSource, UITextFieldDelegate {
    
    // Static flag to track top-up transactions
    public static var isTopUpTransaction: Bool = false
    

    @IBOutlet weak var buttonSpaceBottom: NSLayoutConstraint!
    
    @IBOutlet weak var amountCollectionView: UICollectionView!
    
    @IBOutlet weak var contenContainer: UIView!
    @IBOutlet weak var TitleLabel: UILabel!
    @IBOutlet weak var walletNo: UILabel!
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var balanceLabel: UILabel!
    @IBOutlet weak var amountLabel: UILabel!
    @IBOutlet weak var currencyLabel: UILabel!
    @IBOutlet weak var bottomView: UIView!
    @IBOutlet weak var chooseAmountLabel: UILabel!
    @IBOutlet weak var lineChooseAmount: UIView!
    @IBOutlet weak var inputAmount: UITextField!
    @IBOutlet weak var buttonOk: UIButton!
    
    var amountList:[String] = ["10","20","40","50","100","200"]

    let usdAmountList: [String] = ["10", "20", "40", "50", "100", "200"]
    let khrAmountList: [String] = ["10,000", "20,000", "40,000", "50,000", "100,000", "200,000"]
    var currentAmountList: [String] = []

    var defaultSelectedIndex: IndexPath = IndexPath(row: 0, section: 0) // Default item index

    var language:String?
    var walletId:String=""
    var walletName:String = ""
    var wallet: String = ""
    var balance: String = ""
    var currency: String = ""
    var currencyCode:String=""
    var currencySymbol:String=""
    
    var topUpAmount:String?
    
    let numberFormatter: NumberFormatter = {
            let formatter = NumberFormatter()
            formatter.numberStyle = .decimal
            formatter.groupingSeparator = "," // Optional: Change this if you need a different separator
            formatter.groupingSize = 3 // Optional: This is the default, which groups digits in sets of 3
            return formatter
        }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = DefaultAppearance.shared.primaryColor
        
        getSharePref()
        
        keyboardHidden()
        
       
        // Set the current amount list based on currency
        updateAmountListForCurrency()

       
        B24PaymentSdkHelper.getCurrentLanguage(language: language)
        
        applyToolBar()
        
        inputAmount.delegate = self
        inputAmount.addTarget(self, action: #selector(textFieldDidChange(_:)), for: .editingChanged)
        
        setUpTopUI()
        setUpBottomUI()
        setUpColelctionView()
        
        
        //register keyboard
        NotificationCenter.default.addObserver(self, selector: #selector(keyboardWilldisplay), name:UIResponder.keyboardWillShowNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(keyboardWillHide), name:UIResponder.keyboardWillHideNotification, object: nil)
        

    }
    
    func textFieldDidEndEditing(_ textField: UITextField) {
            // Format and get the value from the text field
            if let text = textField.text {
                topUpAmount = text // Pass the value to topupAmount
                print("Amount after editing: \(topUpAmount)")
            }
        }
    
    
    @objc func keyboardWillHide(){
        UIView.animate(withDuration: 0.3) {
            self.buttonSpaceBottom.constant = 52
        }
       
    }
    
    @objc func keyboardWilldisplay(notification:Notification){
        if let keyboardframe:NSValue = notification.userInfo?[UIResponder.keyboardFrameEndUserInfoKey] as? NSValue{
            let keyboardrectangle = keyboardframe.cgRectValue
            let keyboardHeight = keyboardrectangle.height
            
            UIView.animate(withDuration: 0.3) {
                self.buttonSpaceBottom.constant = keyboardHeight + 10
            }
           
            
        }
    }
    
    func keyboardHidden(){
        let tap = UITapGestureRecognizer(target: self, action: #selector(keyboardRemove))
        tap.cancelsTouchesInView = false
        self.view.addGestureRecognizer(tap)
    }
    
    @objc func keyboardRemove(){
        view.endEditing(true)
    }
    
    @objc func textFieldDidChange(_ textField: UITextField) {
        
        guard var currentText = textField.text else { return }

            if currency == "KHR" {
                // For KHR, allow only numeric characters (no decimals)
                currentText = currentText.replacingOccurrences(of: "[^0-9]", with: "", options: .regularExpression)
            } else {
                // Allow numbers and a single decimal point
                let regexPattern = "[^0-9.]"
                currentText = currentText.replacingOccurrences(of: regexPattern, with: "", options: .regularExpression)

                // Ensure only one decimal point is allowed and limit to 2 digits after decimal
                let components = currentText.components(separatedBy: ".")
                if components.count > 2 {
                    // Retain only the part before the first decimal point
                    currentText = components[0] + "." + components[1].prefix(2)
                } else if components.count == 2 {
                    // If there's already a decimal point, limit to 2 digits after the point
                    let integerPart = components[0]
                    let decimalPart = components[1].prefix(2) // Limit to 2 digits after decimal
                    currentText = integerPart + "." + decimalPart
                }
            }

            // If the input ends with a decimal point, allow it temporarily
            if currentText.last == "." {
                textField.text = currentText
                return
            }

            // Convert to a number for formatting
            if let number = Double(currentText) {
                textField.text = numberFormatter.string(from: NSNumber(value: number))
            } else {
                // Reset invalid or empty input
                textField.text = "0"
            }
      
    }
    func getSharePref(){
        if let languageCode = SharedPreferenceManager.getString(forKey: SharePrefKey.lanuageCode.rawValue){
            language = languageCode
        }else{
            language = "km"
        }
        if let pmId = SharedPreferenceManager.getString(forKey: SharePrefKey.paymentMethodId.rawValue){
            walletId = pmId
        }else{
            walletId = ""
        }
        if let walletN = SharedPreferenceManager.getString(forKey: SharePrefKey.walletNo.rawValue){
            wallet = walletN
        }else{
            wallet = ""
        }
        if let amount = SharedPreferenceManager.getString(forKey: SharePrefKey.balance.rawValue){
            balance = amount
        }else{
            balance = ""
        }
        if let CurrencyCode = SharedPreferenceManager.getString(forKey: SharePrefKey.currency.rawValue){
            currency = CurrencyCode
        }else{
            currency = ""
        }
        
        if let name = SharedPreferenceManager.getString(forKey: SharePrefKey.walletName.rawValue){
            walletName =  name
        }else{
            walletName = ""
        }
        
    }
    
    
    private func applyToolBar(){
            
            let customButton = UIButton(type: .system)
            customButton.translatesAutoresizingMaskIntoConstraints = false
            // Image
            let imageView = UIImageView(image: UIImage(systemName: "chevron.backward"))
            imageView.tintColor = DefaultAppearance.shared.onPrimaryColor
            imageView.contentMode = .scaleAspectFit
            imageView.translatesAutoresizingMaskIntoConstraints = false
            customButton.addSubview(imageView)
            
            let titleLabel = UILabel()
            
            
            titleLabel.text = B24PaymentSdkHelper.localized(TopupLocalizedKeys.topup.rawValue)
            
            titleLabel.textColor = DefaultAppearance.shared.onPrimaryColor
        titleLabel.font = FontManager.shared.mediumFont(forLanguage: language ?? "km", fontFromconfig: DefaultAppearance.shared.fontEnglish,size: FixFontSize.toolbarTitle)
            titleLabel.translatesAutoresizingMaskIntoConstraints = false
            customButton.addSubview(titleLabel)

            // Add constraints to position the image and title properly
            NSLayoutConstraint.activate([
                //            imageView.leadingAnchor.constraint(equalTo: customButton.leadingAnchor,constant: 10),
                imageView.leadingAnchor.constraint(equalTo: customButton.leadingAnchor),
                imageView.centerYAnchor.constraint(equalTo: customButton.centerYAnchor),
                //            imageView.widthAnchor.constraint(equalToConstant: 24), // Set desired width
                imageView.widthAnchor.constraint(equalToConstant: 20),
                imageView.heightAnchor.constraint(equalToConstant: 24),
                            
                            
                //            titleLabel.leadingAnchor.constraint(equalTo: imageView.trailingAnchor, constant: 8),
                titleLabel.leadingAnchor.constraint(equalTo: imageView.trailingAnchor, constant: 4),
                titleLabel.centerYAnchor.constraint(equalTo: customButton.centerYAnchor),
                //            titleLabel.trailingAnchor.constraint(equalTo: customButton.trailingAnchor,constant: -10)
                titleLabel.trailingAnchor.constraint(equalTo: customButton.trailingAnchor, constant: -5),
            ])

            // Add action to the button
            customButton.addTarget(self, action: #selector(backButtonTapped), for: .touchUpInside)

            // Create a UIBarButtonItem with the custom button
            let backButton = UIBarButtonItem(customView: customButton)
            navigationItem.leftBarButtonItem = backButton
        }
        
        // Back button action
        @objc func backButtonTapped() {
            //navigationController?.popViewController(animated: true)
            if let navigationController = navigationController {
                if navigationController.viewControllers.count > 1 {
                    // Pop if not the root view controller
                    navigationController.popViewController(animated: true)
                } else {
                    // Dismiss if this is the root view controller
                    dismiss(animated: true, completion: nil)
                }
            } else {
                // Dismiss if not in a navigation controller
                dismiss(animated: true, completion: nil)
            }
        }
    
    

    func updateAmountListForCurrency() {
        switch currency.uppercased() {
        case "USD":
            currentAmountList = usdAmountList
        case "KHR":
            currentAmountList = khrAmountList
        default:
            currentAmountList = usdAmountList // Default to USD if unknown currency
        }
    }

    
//    func setUpColelctionView(){
//        
//        // Register the custom cell
//        let nibName = UINib(nibName: "AmountViewCell", bundle: B24PaymentSdkHelper.frameworkBundle())
//        self.amountCollectionView.register(nibName, forCellWithReuseIdentifier: "AmountViewCell")
//                
//        self.amountCollectionView.delegate = self
//        self.amountCollectionView.dataSource = self
//                
//        self.amountCollectionView.reloadData()
//        // Select the default item
//        amountCollectionView.selectItem(at: defaultSelectedIndex, animated: false, scrollPosition: .centeredVertically)
//        // Set the default item's value to the inputAmount text field
//        topUpAmount = amountList[defaultSelectedIndex.row]
//        inputAmount.text = topUpAmount
//        
//    }

    // Update setUpCollectionView to use currentAmountList
    func setUpColelctionView() {
        let nibName = UINib(nibName: "AmountViewCell", bundle: B24PaymentSdkHelper.frameworkBundle())
        self.amountCollectionView.register(nibName, forCellWithReuseIdentifier: "AmountViewCell")

        self.amountCollectionView.delegate = self
        self.amountCollectionView.dataSource = self

        self.amountCollectionView.reloadData()

        amountCollectionView.selectItem(at: defaultSelectedIndex, animated: false, scrollPosition: .centeredVertically)
        topUpAmount = currentAmountList[defaultSelectedIndex.row]
        inputAmount.text = topUpAmount
    }

    
    func setUpTopUI(){
        
        inputAmount.keyboardType = .decimalPad
        
        contenContainer.backgroundColor = DefaultAppearance.shared.cardColor
        contenContainer.addCardShadow(cornerRadius: 8)
        contenContainer.roundCorners(cornerRadius: 8)
        line.backgroundColor = DefaultAppearance.shared.primaryLabelColor.withAlphaComponent(0.1)
        
        TitleLabel.text = walletName
        TitleLabel.textColor = DefaultAppearance.shared.primaryLabelColor
//        TitleLabel.font = FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText)
        TitleLabel.font = B24PaymentSdkHelper.setFont(named: FixFontFamily.fontEnglishMedium, ofSize: FixFontSize.contentText)
        
        walletNo.text = wallet
        walletNo.textColor = DefaultAppearance.shared.primaryLabelColor
        walletNo.font = FontManager.shared.mediumFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        
        balanceLabel.text = B24PaymentSdkHelper.localized(AddWalletLocalizedKeys.balance.rawValue)
        balanceLabel.textColor = DefaultAppearance.shared.primaryLabelColor
        balanceLabel.font = FontManager.shared.regularFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        
        amountLabel.text = balance
        amountLabel.textColor = DefaultAppearance.shared.primaryLabelColor
        amountLabel.font = FontManager.shared.mediumFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        
        currencyLabel.text = currency
        currencyLabel.textColor = DefaultAppearance.shared.primaryLabelColor
//        currencyLabel.font = FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText)
        currencyLabel.font = B24PaymentSdkHelper.setFont(named: FixFontFamily.fontEnglishRegular, ofSize: FixFontSize.contentText)
        
        inputAmount.font = B24PaymentSdkHelper.setFont(named: FixFontFamily.fontEnglishMedium, ofSize: FixFontSize.buttonText)
        
    }
    
    func setUpBottomUI() {
        bottomView.backgroundColor = DefaultAppearance.shared.screenBgColor
        chooseAmountLabel.text = B24PaymentSdkHelper.localized(AddWalletLocalizedKeys.choose_amount.rawValue)
        chooseAmountLabel.font = FontManager.shared.regularFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        chooseAmountLabel.textColor = DefaultAppearance.shared.primaryLabelColor

        lineChooseAmount.backgroundColor = DefaultAppearance.shared.primaryLabelColor.withAlphaComponent(0.1)

        // Configure input amount text field
        inputAmount.backgroundColor = DefaultAppearance.shared.cardColor
        inputAmount.layer.cornerRadius = 4
        inputAmount.font = B24PaymentSdkHelper.setFont(named: FixFontFamily.fontEnglishMedium, ofSize: FixFontSize.buttonText)
        inputAmount.textColor = DefaultAppearance.shared.primaryLabelColor
        self.addPadding(to: inputAmount)

        amountCollectionView.backgroundColor = DefaultAppearance.shared.screenBgColor

//        buttonOk.titleLabel?.font = FontManager.shared.mediumFont(forLanguage: language ?? "km", size: FixFontSize.buttonText)
//        buttonOk.setTitle(B24PaymentSdkHelper.localized(TopupLocalizedKeys.continueKey.rawValue), for: .normal)
        buttonOk.tintColor = DefaultAppearance.shared.primaryColor
        //buttonOk.setTitleColor(DefaultAppearance.shared.onPrimaryColor, for: .normal)
        
        let buttonAttribute = NSAttributedString(
                    string: B24PaymentSdkHelper.localized(TopupLocalizedKeys.continueKey.rawValue),
                    attributes: [
                        .font: FontManager.shared.regularFont(forLanguage: self.language ?? "km", fontFromconfig: DefaultAppearance.shared.fontEnglish,size: FixFontSize.buttonText),
                        .foregroundColor: DefaultAppearance.shared.onPrimaryColor
                    ]
                )
        self.buttonOk.setAttributedTitle(buttonAttribute, for: .normal)
       
    }

    // Add a helper method to get currency symbol
    private func getCurrencySymbol(for currency: String) -> String {
        
        var currencyCodeSymbol="";
        
        if(SDKVariableSetting.isDislpayCurrencySymbol){
            currencyCodeSymbol=currencySymbol
        }else{
            currencyCodeSymbol=currencyCode
        }
        
        switch currency.uppercased() {
        case "USD":
            return currencyCodeSymbol
        case "KHR":
            return currencyCodeSymbol
        default:
            return currency // Return the currency code if no symbol is found
        }
    }

    // Update the addPadding method to handle different currencies
    func addPadding(to textField: UITextField) {
        let currencySymbol = getCurrencySymbol(for: currency)
        let currencyLabel = UILabel()
        currencyLabel.text = currencySymbol
        //currencyLabel.font = textField.font
        currencyLabel.font = FontManager.shared.regularFont(forLanguage: "en" ,fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        currencyLabel.textColor = DefaultAppearance.shared.primaryLabelColor
        currencyLabel.sizeToFit()

        let paddingView = UIView(frame: CGRect(x: 0, y: 0, width: currencyLabel.frame.width + 20, height: textField.frame.height))
        currencyLabel.frame = CGRect(x: 10, y: (textField.frame.height - currencyLabel.frame.height) / 2, width: currencyLabel.frame.width, height: currencyLabel.frame.height)
        paddingView.addSubview(currencyLabel)

        textField.leftView = paddingView
        textField.leftViewMode = .always
        
        
        // Add clear button on the right
        let clearButton = UIButton(type: .custom)
        clearButton.setImage(UIImage(systemName: "xmark.circle.fill"), for: .normal)
        clearButton.tintColor = DefaultAppearance.shared.primaryLabelColor
        clearButton.frame = CGRect(x: 0, y: 0, width: 30, height: 20)
            
        // Center the button vertically in the text field
        let buttonPaddingView = UIView(frame: CGRect(x: 10, y: 0, width: 30, height: textField.frame.height))
        clearButton.frame = CGRect(x: 5, y: (textField.frame.height - clearButton.frame.height) / 2, width: 20, height: 20)
        buttonPaddingView.addSubview(clearButton)
            
        // Add action to clear the text field
        clearButton.addTarget(self, action: #selector(clearTextField(_:)), for: .touchUpInside)
            
        textField.rightView = buttonPaddingView
        textField.rightViewMode = .always // Show clear button only when editing
    }
    
    // Selector method to clear the text field
    @objc func clearTextField(_ sender: UIButton) {
        // Find the text field associated with the button
        if let textField = sender.superview?.superview as? UITextField {
            textField.text = "0"
            topUpAmount = "0"
        }
    }

    // Update collection view methods to use currentAmountList
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return currentAmountList.count
    }

//    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
//        let cell = amountCollectionView.dequeueReusableCell(withReuseIdentifier: "AmountViewCell", for:indexPath) as! AmountViewCell
//
//        let amount = amountList[indexPath.row]
//        
//        configAmountCell(cell, with: amount)
//        
//        // Highlight the default selected cell
//        if indexPath == defaultSelectedIndex {
//            cell.container.backgroundColor = DefaultAppearance.shared.primaryColor
//            cell.amountLabel.textColor = DefaultAppearance.shared.onPrimaryColor
//        } else {
//            cell.container.backgroundColor = DefaultAppearance.shared.cardColor
//        }
//        
//        return cell
//        
//    }


    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = amountCollectionView.dequeueReusableCell(withReuseIdentifier: "AmountViewCell", for: indexPath) as! AmountViewCell

        let amount = currentAmountList[indexPath.row]
        configAmountCell(cell, with: amount)
        
        cell.amountLabel.font = FontManager.shared.regularFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)

        if indexPath == defaultSelectedIndex {
            cell.container.backgroundColor = DefaultAppearance.shared.primaryColor
            cell.amountLabel.textColor = DefaultAppearance.shared.onPrimaryColor
        } else {
            cell.container.backgroundColor = DefaultAppearance.shared.cardColor
        }

        return cell
    }

//    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
//        if let cell = collectionView.cellForItem(at: indexPath) as? AmountViewCell {
//            cell.container.backgroundColor = DefaultAppearance.shared.primaryColor
//            cell.amountLabel.textColor = DefaultAppearance.shared.onPrimaryColor
//        }
//
//        topUpAmount = amountList[indexPath.row]
//        inputAmount.text = topUpAmount
//
//        // Reapply padding to ensure currency symbol is correctly displayed
//        self.addPadding(to: inputAmount)
//    }


    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if let cell = collectionView.cellForItem(at: indexPath) as? AmountViewCell {
            cell.container.backgroundColor = DefaultAppearance.shared.primaryColor
            cell.amountLabel.textColor = DefaultAppearance.shared.onPrimaryColor
        }

        topUpAmount = currentAmountList[indexPath.row]
        inputAmount.text = topUpAmount

        self.addPadding(to: inputAmount)
    }

    func collectionView(_ collectionView: UICollectionView, didDeselectItemAt indexPath: IndexPath) {
        // Get the deselected cell
        if let cell = collectionView.cellForItem(at: indexPath) as? AmountViewCell {
            // Revert the background color to the default
            cell.container.backgroundColor = DefaultAppearance.shared.cardColor
            cell.amountLabel.textColor = DefaultAppearance.shared.primaryLabelColor
        }
    }
    
    
    func configAmountCell(_ cell:AmountViewCell, with amount:String){
        cell.container.backgroundColor = DefaultAppearance.shared.cardColor
        cell.container.layer.cornerRadius = 6
        cell.amountLabel.text = amount
        cell.amountLabel.font = B24PaymentSdkHelper.setFont(named: FixFontFamily.fontEnglishMedium, ofSize: FixFontSize.buttonText)
        cell.amountLabel.textColor = DefaultAppearance.shared.primaryLabelColor
    }
    
    
    @IBAction func okButtonAction(_ sender: Any) {
        
       topupWallet()
        
//        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
//        let vc = storyboard.instantiateViewController(withIdentifier: "SuccessScreenViewController") as! SuccessScreenViewController
//       // vc.transactionSuccess = transaction
//        if let navigationController = self.navigationController {
//            navigationController.pushViewController(vc, animated: true)
//        } else {
//            // If no navigation controller, you can either show an error or fallback to presenting modally
//            print("Navigation Controller not found.")
//        }
        
    }
    
    func topupWallet(){
        
       // print("====TOPUP AMOUNT \(String(describing: topUpAmount))")
        
        let amountWithoutComma = topUpAmount?.replacingOccurrences(of: ",", with: "")
        
        let amount = Decimal(string: amountWithoutComma ?? "0")
        
        if(amount == 0 || (currency=="KHR" && amount ?? 0 <= 100)){
            B24PaymentSdkHelper.errorSnackbar(
                    view: view,
                message: B24PaymentSdkHelper.localized(SnackBarLocalizedKeys.amount_zero.rawValue),
                                                forBottomSheet: false
                                            )
            
            return
        }
        
      //  print("amount is : \(String(describing: amount))")
        
        let payload = TopUp(id: walletId, amount: amount ?? 0.0)
        
        do {
            let jsonData = try JSONEncoder().encode(payload)
            guard let jsonString = String(data: jsonData, encoding: .utf8) else {
                showError(message: "Failed to create payload")
                return
            }

            let encryptedText = try EncryptionHelper.encryptHMACAES(
                plainText: jsonString,
                secretKey: SDKVariableSetting.walletSecretKey
            )
           
            sendRequestTopup(encrypt: encryptedText)

        } catch {
            showError(message: "Encryption failed: \(error.localizedDescription)")
        }
        
    }
    
    //MARK: request Topup
    func sendRequestTopup(encrypt:String){
        let progressDiglog = CustomLoadingView.show(in: self)
        
        AF.request(WalletRouter.topUpWallet(encrypted: encrypt))
            .validate().responseData{
               response in
                switch response.result{
                    case .success(let data):
                    progressDiglog.dismiss()
                        do{
                            let decodedData = try JSONDecoder().decode(ApiResponse<WalletResponseData>.self, from: data)
                            
                            if decodedData.code == StatusCode.succcess.rawValue{
                                
                                guard let encrypted = decodedData.data.encrypted else {
                                    // handle error properly — e.g., throw custom error or show alert
                                    print("❌ Encrypted value is null")
                                    return
                                }
                                
                                let decryptText = try EncryptionHelper.decryptHMACAES(encryptedBase64: encrypted, secretKey:  SDKVariableSetting.walletSecretKey)
                                
                                let decryptedData = decryptText.data(using: .utf8)!
                                
                                // Decode the data into ApiResponse model
                                let checkout = try JSONDecoder().decode(TopUpResponseModel.self, from: decryptedData)
                                
                                //set flag for top-up transaction
                                TopUpView.isTopUpTransaction = true
                                
                                let isProduction = SharedPreferenceManager.getBool(forKey: SharePrefKey.isProduction.rawValue)
                                                               
                                let testEnv = SharedPreferenceManager.get(forKey: SharePrefKey.environment.rawValue) as? String ?? "DEMO"
                                
                               
                                B24PaymentSdk().initSdk(controller: self,
                                                      transactionId: checkout.tranId,
                                                      refererKey: SDKVariableSetting.xRefererKey,
                                                      language: self.language,
                                                      darkMode:SDKVariableSetting.isDarkMode,
                                                      isProduction: isProduction,
                                                      testingEnv:testEnv
                                                      
                                )
                            }else{
                                let message = self.language == "en" ? decodedData.message : decodedData.messageKh
                                
                                B24PaymentSdkHelper.errorSnackbar(view: self.view,
                                                                  message: message )
                            }
                            
                            
                            
//                              print("Transaction ID: \(checkout.tranId)")
//                              print("Identity Code: \(checkout.identityCode)")
//                              print("Payment Link: \(checkout.paymentLink)")
//                              print("KHQR String: \(checkout.khqrString)")

//                            print("===========>\(decodedData)")
//                            print("===========>\(decryptText)")
                        }catch {
                            print("Decode Error: \(error)")
                        }
                    
                    case.failure(let error):
                        progressDiglog.dismiss()
                        B24PaymentSdkHelper.errorSnackbar(
                            view: self.view,
                            message: B24PaymentSdkHelper.localized(SnackBarLocalizedKeys.error_connect_server.rawValue),
                            forBottomSheet: false
                    )
                        print("ERROR \(error)")
                }
            }
    }
    
    private func showError(message: String) {
        DispatchQueue.main.async {
            let alert = UIAlertController(
                title: "Error",
                message: message,
                preferredStyle: .alert
            )
            alert.addAction(UIAlertAction(title: "OK", style: .default))
            self.present(alert, animated: true)
        }
    }
    
}

extension TopUpView: UICollectionViewDelegateFlowLayout {
    // Set cell size
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
//            let itemsPerRow: CGFloat = 3 // Number of items in a row
//            let padding: CGFloat = 20 // Total padding between items
//            let availableWidth = collectionView.frame.width - (padding * (itemsPerRow + 1))
//            let itemWidth = availableWidth / itemsPerRow
//            return CGSize(width: itemWidth, height: itemWidth * 0.6)
            
            let size = (amountCollectionView.frame.size.width)/4
            return CGSize(width: size,height: 60)
            
        }

//        // Set section insets
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
            return UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20) // Padding for the whole section
        }
//
//        // Set spacing between rows
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
            return 20
        }

        // Set spacing between items in the same row
        func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
            return 20
        }
}


