//
//  DottedLineView.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 23/10/23.
//

import Foundation
import UIKit

class DottedLineView: UIView {
    override func draw(_ rect: CGRect) {
        let path = UIBezierPath()
        let dashPattern: [CGFloat] = [6, 6] // Adjust the pattern as needed (e.g., [4, 2, 1, 2] for a more complex pattern)
        path.setLineDash(dashPattern, count: dashPattern.count, phase: 0)
        path.move(to: CGPoint(x: rect.origin.x, y: rect.size.height / 2))
        path.addLine(to: CGPoint(x: rect.size.width, y: rect.size.height / 2))
        
        if let dotlineColor = UIColor(
            named: "dotline_color",
            in: B24PaymentSdkHelper.frameworkBundle(),
            compatibleWith: nil
        ) {
            dotlineColor.setStroke() // Set the color of the dotted line
            path.stroke()
        } else {
            // Fallback color in case the asset color is not found
            UIColor.gray.setStroke() // Set the color of the dotted line to gray as a fallback
            path.stroke()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.backgroundColor = .clear // Set background color to clear
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        self.backgroundColor = .clear // Set background color to clear
    }
}
