//
//  SnackbarView.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 26/10/23.
//

import Foundation
import UIKit

class SnackbarView: UIView {
    
    @IBOutlet weak var message: UILabel!
    @IBOutlet weak var iconImage: UIImageView!
    var snackbarBackground: UIColor!
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        registerView()
    }

    init(frame: CGRect, backgroundColor: UIColor) {
        self.snackbarBackground = backgroundColor
        super.init(frame: frame)
        registerView()
    }
    
    private func registerView() {
        let nib = UINib(nibName: "SnackbarView", bundle: B24PaymentSdkHelper.frameworkBundle()!)

        guard let view = nib.instantiate(withOwner: self, options: nil).first as?
                            UIView else {fatalError("Unable to convert nib")}

        view.frame = bounds
        view.autoresizingMask = [.flexibleWidth, .flexibleHeight]
        view.backgroundColor = snackbarBackground

        addSubview(view)
        print("*** Load Snackbar ***")
    }
}
