
Pod::Spec.new do |spec|
  spec.name         = "B24PaymentSdk"
  spec.version      = "1.1.54"
  spec.summary      = "B24PaymentSdk is a swift framework library"
  spec.description  = "B24PaymentSdk is a swift framework library that provides payment methods via bank deeplink, bank web checkout, and KHQR."

  spec.homepage     = "https://bill24.com.kh/en/"
  spec.license      = { :type => 'MIT', :file => 'LICENSE' }
    
  spec.author       = { "Bill24CoLtd" => "bill24.net@gmail.com" }

  spec.platform     = :ios, '13.0'
  spec.swift_version = '5.0'
  spec.ios.deployment_target = "13.0"

  spec.source        = { :http => "https://b24sdk.s3.ap-southeast-1.amazonaws.com/B24PaymentSdk-1-1-54.zip" }

  spec.source_files  = 'B24PaymentSdk/**/*.swift', 'B24PaymentSdk/**/**/*.swift'

  spec.resource_bundle = {
    'B24PaymentSdk' => ['B24PaymentSdk/Assets/**/*', 'B24PaymentSdk/Localizable/**/*', 'B24PaymentSdk/Views/**/*']
  }

  spec.info_plist = {
    'CFBundleIdentifier' => 'com.bill24.B24PaymentSdk'
  }

  spec.pod_target_xcconfig = { 
    'PRODUCT_BUNDLE_IDENTIFIER': 'com.bill24.B24PaymentSdk' 
  }
  spec.ios.framework  = 'UIKit'
  spec.exclude_files  = ['Classes/Exclude']
  spec.dependency "Starscream", "4.0.6"
  spec.dependency "Alamofire", "~> 5.4"
  spec.dependency "Socket.IO-Client-Swift", "~>16.1.0"

  # Add the following line to include the README file
  # spec.readme = 'https://github.com/Bill24CoLtd/IOS-B24PaymentSdk/blob/main/README.md'
  # spec.documentation_url = 'https://bill24.com.kh/en/'
  # spec.readme = 'https://b24sdk.s3.ap-southeast-1.amazonaws.com/README.md'
  spec.readme = 'https://github.com/Bill24CoLtd/IOS-B24PaymentSdk/blob/main/README.md'
  spec.documentation_url = 'https://github.com/Bill24CoLtd/IOS-B24PaymentSdk'
end
