//
//  BankCollectionViewCell.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 16/10/23.
//

import Foundation
import UIKit

public class BankCollectionViewCell: UICollectionViewCell{
    @IBOutlet weak var bankLogoUIView: UIView!
    @IBOutlet weak var cardView: UIView!
    @IBOutlet weak var favoriteView: UIView!
    @IBOutlet weak var bankLogo: UIImageView!
    @IBOutlet weak var bankName: UILabel!
    @IBOutlet weak var bankFee: UILabel!
    @IBOutlet weak var favoriteIcon: UIImageView!
    @IBOutlet weak var feeLabel: UILabel!
    @IBOutlet weak var bankNameTopConstraint: NSLayoutConstraint!
    var isFavourite: Bool!
    
//    override public func prepareForReuse() {
//        super.prepareForReuse()
//    }
    
    public override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    func setUp(with item: BankPaymentItem, tranInfo: TransInfo, setting: Setting){
        if(SDKVariableSetting.currentLanguage.lowercased() == "en"){
            bankName.text = item.name ?? item.nameKh
            feeLabel.text = "Fee:"
        }else{
            bankName.text = item.nameKh ?? item.name
            feeLabel.text = "ថ្លៃសេវា:"
        }
        
        bankFee.text = item.feeDisplay
        
        bankLogo.loadImage(from: item.logo, placeholder: UIImage(named: "default-bank",  in: B24PaymentSdkHelper.frameworkBundle(),compatibleWith: nil))
        
        //setup favorite
        if(item.isFavorite == true){
            favoriteIcon.image = UIImage(systemName: "star.fill")
            isFavourite = item.isFavorite
        }else{
            favoriteIcon.image = UIImage(systemName: "star")
            isFavourite = item.isFavorite
        }
        
        // disable allowFavorite
        if(tranInfo.isAllowFavorite == false){
            favoriteView.isHidden = true
        }else{
            favoriteIcon.isHidden = false
        }
        
        // disable fee
        if (setting.displayFee == true){
            if(item.fee == 0){
                feeLabel.isHidden = true
                bankFee.isHidden = true
                bankNameTopConstraint.constant = 0.3 * contentView.bounds.height
            }else{
                feeLabel.isHidden = false
                bankFee.isHidden = false
            }
        }else{
            feeLabel.isHidden = true
            bankFee.isHidden = true
            bankNameTopConstraint.constant = 0.3 * contentView.bounds.height
        }
        
        // disable fee when fee=0
//        if(item.fee == 0){
//            feeLabel.isHidden = true
//            bankFee.isHidden = true
//            bankNameTopConstraint.constant = 0.3 * contentView.bounds.height
//        }else{
//            feeLabel.isHidden = false
//            bankFee.isHidden = false
//        }
        
        // Update the layout
        contentView.layoutIfNeeded()
    }
    
    
    func setUpStyleAndConstraintCell(){
        cardView.layer.cornerRadius = 12
        bankLogoUIView.layer.cornerRadius = 6
        bankLogo.layer.cornerRadius = 6
        favoriteView.layer.cornerRadius = 6

        cardView.backgroundColor =  UIColor(named: "card_primary_color", in: B24PaymentSdkHelper.frameworkBundle(), compatibleWith: nil)
        cardView.backgroundColor = UIColor(hex: Themes.Property.bankButtonBackgroundColor)
        bankName.textColor = UIColor(hex: Themes.Property.bankButtonTextPrimaryColor)
        feeLabel.textColor = UIColor(hex: Themes.Property.bankButtonTextSecondaryColor)
        bankFee.textColor = UIColor(hex: Themes.Property.bankButtonTextSecondaryColor)
        favoriteView.backgroundColor = UIColor(hex: Themes.Property.favoriteButtonBackgroundColor)
        favoriteIcon.tintColor = UIColor(hex: Themes.Property.favoriteButtonTextColor)
        
    }
    
    
    func setUpFontAndTranslateBankCollectionView(){
        bankName.font = FontManager.shared.mediumFont(forLanguage: SDKVariableSetting.currentLanguage, size: 13.0)
        feeLabel.font =  FontManager.shared.regularFont(forLanguage: SDKVariableSetting.currentLanguage, size: 13.0)
        bankFee.font = B24PaymentSdkHelper.setFont(named: "Roboto-Regular", ofSize: 13.0)
        
        feeLabel.text =  B24PaymentSdkHelper.localized(PaymentMethodLocalizedKeys.fee.rawValue)
    }
    
}
