//
//  Translation.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 7/11/23.
//

import Foundation

public enum PaymentMethodLocalizedKeys: String {
    case title = "payment_method_tile"
    case fee =  "payment_method_fee_label"
    case amount = "transaction_amount"
}

public enum SnackBarLocalizedKeys: String{
    case error = "error"
    case saveKhqr = "save_khqr"
    case saveReceipt = "save_receipt"
    case payment_success = "payment_success"
    case amount_zero = "amount_zero_error"
    case error_connect_server = "msg_error_connect"
    case connection_restored = "msg_connection_restored"
}

public enum KhqrLocalizedKeys: String{
    case scanToPay = "scan_label"
    case or = "or_label"
}

public enum LocalizedKeys: String{
    case download = "download_label"
    case share = "share_label"
}

public enum ExpireLocalizedKeys: String{
    case title = "expire_title"
    case description = "expire_description"
    case button = "expire_button"
}

public enum SuccessLocalizedKeys: String {
    case title = "success_title"
    case transactionNo = "success_transaction_no_label"
    case bankRef = "success_bank_ref_label"
    case merchantName = "success_merchant_name_label"
    case transactionDate = "success_transaction_date_label"
    case totalLabel = "success_total_label"
    case button = "success_done_button"
    case feeLabel = "fee_label"
    case originalAmountLabel = "original_amount_label"
    case copy = "copy_to_board"
}



//Digital Wallet
public enum AddWalletLocalizedKeys:String{
    case add_payment_method = "add_payment_method"
    case title = "add_wallet_title"
    case balance = "balance"
    case choose_amount = "choose_amount"
    case save_button = "save"
    case placeholder_wallet_name = "placeholder_wallet_name"
    case done = "done"
    case required = "required"
    case can_not_create_wallet="can_not_create_wallet"
    case view_all = "view_all"
}

public enum PaymentMethodWalletLocalizedKeys:String{
    case payment_method_title = "payment_method"
    case inActive = "inactive"
    case DefaultACC = "default_acc"
    case emptyText = "empty_text"
    case empty = "empty"
    case msg_no_apm = "msg_no_apm"
}

public enum AccountDetailLocalizedKeys:String{
   case accNo =  "detail_account_no"
   case detail_account_name
   case walletId = "detail_wallet_id"
   case walletId2 = "wallet_id"
   case detail_wallet_ballance
   case detail_currency
   case detail_set_default
   case detail_enable
   case detail_disable
   case detail_top_up
   case cannot_topup = "topup_msg"
   case title = "wallet_title_id"
   case image_save = "tran_detail_image"
   case no_tran_history = "no_tran_history"
  
}

public enum TransactionDetailLocalizedKeys:String{
    
   case tran_id
   case invoice_id
   case paid_to
   case payment_from
   case origial_amount
   case fee_amount
   case reference
   case tran_date
   case tran_recent = "tran_recent"
}

public enum DialogLocalizedKeys:String{
    case waring_first = "warning_first_label"
    case warning_two = "warning_second_label"
    case ok
    case cancel
    case set_default = "set_default_message"
    case enable = "enable_message"
    case active = "active"
    case topup_waning = "topup_msg"
    case no_internet_title = "no_internet_title"
    case no_internet_msg = "no_internet_msg"
    case waiting_connection = "waiting_connection"
}

public enum TopupLocalizedKeys:String{
    case continueKey = "continue"
    case topup = "top_up"
    
}

public enum WalletSuccessLocalizedKeys:String{
    case title = "success_title"
    case sub_title = "success_sub_title"
    case done = "success_done"
}
