//
//  DefaultAppearance.swift
//  B24PaymentSdk
//
//  Created by visal ny on 19/12/24.
//

import Foundation
import UIKit

class DefaultAppearance{
    static let shared = DefaultAppearance() // Singleton instance
        
        private init() {}
    
        // Default color values
        var primaryColor: UIColor = UIColor(hex: "#000000")
        var screenBgColor: UIColor = UIColor(hex: "#000000")
        var primaryLabelColor: UIColor = UIColor(hex: "#000000")
        var secondaryLabelColor: UIColor = UIColor(hex: "#06417D")
        var cardColor: UIColor = UIColor(hex: "#FFFFFF")
        var onPrimaryColor: UIColor = UIColor(hex: "#FFFFFF")
        var dangerColor: UIColor = UIColor(hex: "#FE608A")
        var warningColor: UIColor = UIColor(hex: "#FFC668")
    
        //font name
       var fontEnglish:String? = ""
       var fontKhmer:String? = ""
        
        // Error Background Color
        static let bgError: UIColor = UIColor(hex: "#FAEEEE")
        
        // Set appearance based on mode
        func setAppearance(_ appearance: DWalletAppearance, isDarkMode: Bool) {
            
            fontEnglish =  appearance.fontEnglish
            fontKhmer = appearance.fontKhmer
            
            if isDarkMode {
                let darkMode = appearance.darkMode ?? DWalletMode()
                primaryColor = UIColor(hex: darkMode.primaryColor) 
                screenBgColor = UIColor(hex: darkMode.screenBgColor) 
                primaryLabelColor = UIColor(hex: darkMode.primaryLabelColor) 
                secondaryLabelColor = UIColor(hex: darkMode.secondaryLabelColor) 
                cardColor = UIColor(hex: darkMode.cardColor)
                onPrimaryColor = UIColor(hex: darkMode.onPrimaryColor)
                dangerColor = UIColor(hex: darkMode.dangerColor)
                warningColor = UIColor(hex: darkMode.warningColor)
            } else {
                let lightMode = appearance.lightMode ?? DWalletMode()
                primaryColor = UIColor(hex: lightMode.primaryColor)
                screenBgColor = UIColor(hex: lightMode.screenBgColor)
                primaryLabelColor = UIColor(hex: lightMode.primaryLabelColor)
                secondaryLabelColor = UIColor(hex: lightMode.secondaryLabelColor)
                cardColor = UIColor(hex: lightMode.cardColor)
                onPrimaryColor = UIColor(hex: lightMode.onPrimaryColor)
                dangerColor = UIColor(hex: lightMode.dangerColor)
                warningColor = UIColor(hex: lightMode.warningColor)
            }
        }
}
