import UIKit

class CustomLoadingView: UIView {
    static func show(in viewController: UIViewController) -> CustomLoadingView {
        let loadingView = CustomLoadingView(frame: .zero)
        loadingView.backgroundColor = UIColor.black.withAlphaComponent(0.1) // Optional: semi-transparent background
        loadingView.translatesAutoresizingMaskIntoConstraints = false
        
        // Add loading indicator (e.g., UIActivityIndicatorView)
        let activityIndicator = UIActivityIndicatorView(style: .large)
        activityIndicator.color = DefaultAppearance.shared.primaryColor
        activityIndicator.startAnimating()
        activityIndicator.translatesAutoresizingMaskIntoConstraints = false
        loadingView.addSubview(activityIndicator)
        
        // Center the activity indicator in the loading view
        NSLayoutConstraint.activate([
            activityIndicator.centerXAnchor.constraint(equalTo: loadingView.centerXAnchor),
            activityIndicator.centerYAnchor.constraint(equalTo: loadingView.centerYAnchor)
        ])
        
        // Add the loading view to the view controller's view
        viewController.view.addSubview(loadingView)
        
        // Set constraints to center the loading view and cover the entire parent view
        NSLayoutConstraint.activate([
            loadingView.centerXAnchor.constraint(equalTo: viewController.view.centerXAnchor),
            loadingView.centerYAnchor.constraint(equalTo: viewController.view.centerYAnchor),
            loadingView.widthAnchor.constraint(equalTo: viewController.view.widthAnchor),
            loadingView.heightAnchor.constraint(equalTo: viewController.view.heightAnchor)
        ])
        
        return loadingView
    }
    
    func dismiss() {
        self.removeFromSuperview()
    }
}
