//
//  AccountDetailResponseModel.swift
//  B24PaymentSdk
//
//  Created by visal ny on 26/12/24.
//

import Foundation

// MARK: - AccountDetailResponseModel
struct AccountDetailResponseModel: Codable {
    let code, message, messageKh: String
    let data: DataAccountDetail

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct DataAccountDetail: Codable {
    let id, type, accountNo, accountName: String
    let amount: Double
    let amountDisplay, currency, logo, title: String
    let isDefault, inactive: Bool
    let currencyCode,currencySymbol:String

    enum CodingKeys: String, CodingKey {
        case id, type
        case accountNo = "account_no"
        case accountName = "account_name"
        case amount
        case amountDisplay = "amount_display"
        case currency, logo, title
        case isDefault = "is_default"
        case inactive
        case currencyCode="currency_code"
        case currencySymbol="currency_symbol"
    }
    
    
    
    // Custom initializer
        init(
            id: String = "7e5e689e-8b8e-4636-a8c8-b614c7859cf3",
            type: String = "wallet",
            accountNo: String = "000000029",
            accountName: String = "Wallet4",
            amount: Double = 0,
            amountDisplay: String = "0.00",
            currency: String = "USD",
            logo: String = "",
            title: String = "Wallet4",
            isDefault: Bool = false,
            inactive: Bool = true,
            currencyCode:String="KHR",
            currencySymbol:String="៛"
        ) {
            self.id = id
            self.type = type
            self.accountNo = accountNo
            self.accountName = accountName
            self.amount = amount
            self.amountDisplay = amountDisplay
            self.currency = currency
            self.logo = logo
            self.title = title
            self.isDefault = isDefault
            self.inactive = inactive
            self.currencyCode=currencyCode
            self.currencySymbol=currencySymbol
        }
}
