//
//  TransactionDetailResponseModel.swift
//  B24PaymentSdk
//
//  Created by visal ny on 26/12/24.
//

import Foundation


// MARK: - TransactionResponseModel
struct TransactionDetailResponseModel: Codable {
    let code, message, messageKh: String
    let data: DataWalletTransactionDetail

    enum CodingKeys: String, CodingKey {
        case code, message
        case messageKh = "message_kh"
        case data
    }
}

// MARK: - DataClass
struct DataWalletTransactionDetail: Codable {
    let tranID, tranType: String
        let totalAmount: Double
        let totalAmountDisplay: String
        let originalAmount: Double
        let originalAmountDisplay: String
        let fee: Double
        let feeDisplay, currency, tranDate, paymentFrom: String
        let paidTo, refNo, tranNo, invoiceId,descriptionEn,descriptionKm, logo: String?

        enum CodingKeys: String, CodingKey {
            case tranID = "tran_id"
            case tranType = "tran_type"
            case totalAmount = "total_amount"
            case totalAmountDisplay = "total_amount_display"
            case originalAmount = "original_amount"
            case originalAmountDisplay = "original_amount_display"
            case fee
            case feeDisplay = "fee_display"
            case currency
            case tranDate = "tran_date"
            case paymentFrom = "payment_from"
            case paidTo = "paid_to"
            case refNo = "ref_no"
            case tranNo = "tran_no"
            case invoiceId = "invoice_id"
            case descriptionEn = "description_en"
            case descriptionKm = "description_km"
            case logo
        }
    
    
    init(
        tranID: String = "caf29a70-a7a5-4b6e-bc9f-bd6b14b3a4d5",
            tranType: String =  "wallet_topup",
            totalAmount: Double = 10.0000,
            totalAmountDisplay: String = "10.00",
            originalAmount: Double = 10.0000,
            originalAmountDisplay: String = "10.00",
            fee:Double = 0.0000,
            feeDisplay: String = "0.00",
            currency: String = "USD",
            tranDate: String = "2024-12-11 10:13:54",
            paymentFrom: String = "AMK",
            paidTo: String = "Ev charge",
            refNo: String = "xTC6hBQrZAmgGg=",
            tranNo: String = "20EA15C53831",
            invoiceId:String = "dddddddddd",
            logo: String = "",
            descriptionEn: String = "",
            descrptionKm: String = ""
        ) {
            self.tranID = tranID
            self.tranType = tranType
            self.totalAmount = totalAmount
            self.totalAmountDisplay = totalAmountDisplay
            self.originalAmount = originalAmount
            self.originalAmountDisplay = originalAmountDisplay
            self.fee = fee
            self.feeDisplay = feeDisplay
            self.currency = currency
            self.tranDate = tranDate
            self.paymentFrom = paymentFrom
            self.paidTo = paidTo
            self.refNo = refNo
            self.tranNo = tranNo
            self.invoiceId = invoiceId
            self.descriptionEn = descriptionEn
            self.descriptionKm = descrptionKm
            self.logo = logo
        }
}
