//
//  APIManager.swift
//  Bill24OnlinePaymentSdk
//
//  Created by MacbookPro on 20/10/23.
//
import Foundation
import Alamofire

public class APIManager
{
    public class func merchantApiUrl() -> URL{
        var url: String
        if(SDKVariableSetting.isProduction == true){
            url = SDKVariableSetting.merchantApiBaseUrlProduction
        }else if (SDKVariableSetting.testingEnv == "STAG"){
            url = SDKVariableSetting.merchantApiBaseUrlStaging
//            url = SDKVariableSetting.merchantApiBaseUrlDemo

        }else if(SDKVariableSetting.testingEnv == "PILOT"){
            url = SDKVariableSetting.merchantApiBaseUrlPilot
        }else{
            url = SDKVariableSetting.merchantApiBaseUrlDemo
        }
        return URL(string: url)!
    }
    
    public class func socketServerUrl() -> URL{
        var socketUrl: String

        if(SDKVariableSetting.isProduction == true){
            socketUrl = SDKVariableSetting.socketBaseUrlProduction
        }else{
            socketUrl = SDKVariableSetting.socketBaseUrlDemo
//            socketUrl = SDKVariableSetting.socketBaseUrlStaging
        }
        return URL(string: socketUrl)!
    }
    
    public class func serviceName() -> String{
        return "KHQR"
    }
    
    public class func openBill24Website() -> String{
        return SDKVariableSetting.bill24WebsiteUrl
    }
    
    public class func initHeader() -> HTTPHeaders{
        return [
            "Content-Type": "application/json",
            "accept": "application/json",
            "token": SDKVariableSetting.apiToken,
            "X-Referrer-Key": SDKVariableSetting.xRefererKey,
        ]
    }
    
    public class func initWalletHeader() -> HTTPHeaders{
        return [
            "Content-Type": "application/json",
            "accept": "application/json",
            "token": SDKVariableSetting.apiToken,
            "X-Referrer-Key": SDKVariableSetting.xRefererKey,
        ]
    }
    
    public class func initHeaderExtendExpireDate() -> HTTPHeaders{
        return [
            "Content-Type": "application/json",
            "accept": "application/json",
            "token": SDKVariableSetting.apiToken,
            "X-Referrer-Key": SDKVariableSetting.xRefererKey,
            "X-Client-Time": B24PaymentSdkHelper.formatDateToString(Date(), format: "yyyy-MM-dd HH:mm:ss")
        ]
    }
}
