//
//  WalletRouter.swift
//  B24PaymentSdk
//
//  Created by visal ny on 17/12/24.
//

import Foundation
import Alamofire

enum WalletRouter: URLRequestConvertible{
   
    case getAppearance
    case getAvailablePMType(customerSyncCode:String?)
    case modifyWalletName(encrypted:String)
    case setDetault(encrypted:String)
    case updateStatus(encrypted:String)
    case topUpWallet(encrypted:String)
    case createWallet(encrypted:String)
    case instantPaymentMethod(customerSynCode:String,filterBy:String)
    case instantPaymentMethodDetail(id:String)
    case transactionDetail(id:String)
    
    
    var params: Parameters?{
        switch self{
            
        case .getAppearance:
            return nil
            
        case .getAvailablePMType(let customerSyncCode):
            if let code = customerSyncCode {
                return ["customerSyncCode": code]
            } else {
                return nil
            }
            
        case .modifyWalletName(let encrypted):
            return ["encrypted": encrypted]
        case .setDetault(let encrypted):
            return ["encrypted": encrypted]
        case .updateStatus(let encrypted):
            return ["encrypted": encrypted]
            
        case .topUpWallet(let encrypted):
            return ["encrypted": encrypted]
            
        case .createWallet(let encrypted):
            return ["encrypted": encrypted]
        case .instantPaymentMethod(let  customerSynCode,let filterBy):
            return ["customer_sync_code":customerSynCode, "filter_by_status":filterBy]
        case .instantPaymentMethodDetail(let id):
            return ["id":id]
        case .transactionDetail(let id):
            return ["id":id]
        }
    
    }
    
    var method:HTTPMethod{
        switch self{
        case .getAppearance:
            return .get
        case .getAvailablePMType:
            return .get
        case .modifyWalletName:
            return .post
        case .setDetault:
            return .post
        case .updateStatus:
            return .post
        case .topUpWallet:
            return .post
        case .createWallet:
            return .post
        case .instantPaymentMethod:
            return .post
        case .instantPaymentMethodDetail:
            return .post
        case .transactionDetail:
            return .post
        }
        
    }
    
    var path:String{
        switch self {
        case .getAppearance:
            return "/instantpaymentsdk/configs"
        case .getAvailablePMType:
            return "/instantpaymentsdk/available_payment_method_type"
        case .modifyWalletName:
            return "/instantpaymentsdk/payment_method/modify"
        case .setDetault:
            return "/instantpaymentsdk/payment_method/set_default"
        case .updateStatus:
            return "/instantpaymentsdk/payment_method/update_status"
        case .topUpWallet:
            return "/instantpaymentsdk/wallet/topup"
        case .createWallet:
            return "/instantpaymentsdk/create/wallet"
        case .instantPaymentMethod:
            return "/instantpaymentsdk/instant_payment_methods"
        case .instantPaymentMethodDetail:
            return "/instantpaymentsdk/payment_method/detail"
        case .transactionDetail:
            return "/instantpaymentsdk/payment_method/transaction_detail"
        }
    }
    
    
    
    func asURLRequest() throws -> URLRequest {
        let url =  APIManager.merchantApiUrl().appendingPathComponent(path)
        var request = URLRequest(url: url)
        request.method = method
        //request.allowsConstrainedNetworkAccess = false
        request.allowsConstrainedNetworkAccess = true
        request.allowsExpensiveNetworkAccess = true

        
        switch self{
        case .getAppearance:
            request.headers = APIManager.initWalletHeader()
        case .getAvailablePMType:
            request.headers = APIManager.initWalletHeader()
        case .modifyWalletName:
            request.headers = APIManager.initWalletHeader()
        case .setDetault:
            request.headers = APIManager.initWalletHeader()
        case .updateStatus:
            request.headers = APIManager.initWalletHeader()
        case .topUpWallet:
            request.headers = APIManager.initWalletHeader()
        case .createWallet:
            request.headers = APIManager.initWalletHeader()
        case .instantPaymentMethod:
            request.headers = APIManager.initWalletHeader()
        case .instantPaymentMethodDetail:
            request.headers = APIManager.initWalletHeader()
        case .transactionDetail:
            request.headers = APIManager.initWalletHeader()
            
        }
        
        // If the method is POST, encode the parameters in the body
        if method == .post, let parameters = params {
            request = try JSONEncoding.default.encode(request, with: parameters)
        } else if method == .get {
                    // For GET request, append parameters to the URL if params is non-nil and non-empty
            if let parameters = params, !parameters.isEmpty {
                var components = URLComponents(url: request.url!, resolvingAgainstBaseURL: false)!
                components.queryItems = parameters.map { URLQueryItem(name: $0.key, value: "\($0.value)") }
                request.url = components.url
            }
        }

        return request
    }
}

