//
//  CustomAlertView.swift
//  B24PaymentSdk
//
//  Created by visal ny on 23/12/24.
//

import UIKit

class CustomAlertView: UIViewController {

    @IBOutlet weak var customContainer: UIView!
    
    @IBOutlet weak var enableImage: UIImageView!
    @IBOutlet weak var icon: UIImageView!
    
    @IBOutlet weak var lblMessage: UILabel!
    
    @IBOutlet weak var buttonOk: UIButton!
    @IBOutlet weak var buttonCancel: UIButton!
    
    var okActionHandler: (() -> Void)?
    var cancelActionHandler: (() -> Void)?
    
    
    var language:String?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = UIColor.black.withAlphaComponent(0.5)
        
        getSharePref()
        B24PaymentSdkHelper.getCurrentLanguage(language: language)
        
        
        setupView()
    
    }
    
    
    func getSharePref(){
        if let languageCode = SharedPreferenceManager.getString(forKey: SharePrefKey.lanuageCode.rawValue){
            language = languageCode
        }else{
            language = "km"
        }
    }
    
    
    func setupView() {
        customContainer.backgroundColor =  DefaultAppearance.shared.cardColor
        customContainer.layer.cornerRadius = 12
        icon.tintColor = DefaultAppearance.shared.primaryColor
        

        lblMessage.font = FontManager.shared.mediumFont(forLanguage: language ?? "km",fontFromconfig: DefaultAppearance.shared.fontEnglish, size: FixFontSize.contentText)
        lblMessage.textColor = DefaultAppearance.shared.primaryLabelColor
        
//        buttonCancel.setTitleColor(DefaultAppearance.shared.primaryLabelColor, for: .normal)
//        buttonCancel.titleLabel?.font = FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText)
        let cancelTitle = NSAttributedString(
            string : B24PaymentSdkHelper.localized(DialogLocalizedKeys.cancel.rawValue),
            attributes: [
                .font: FontManager.shared.regularFont(forLanguage: language ?? "km", fontFromconfig: DefaultAppearance.shared.fontEnglish,size: FixFontSize.contentText),
                .foregroundColor: DefaultAppearance.shared.primaryLabelColor
            ]
        )
        buttonCancel.setAttributedTitle(cancelTitle, for: .normal)
        
        let okTitle = NSAttributedString(
            string : B24PaymentSdkHelper.localized(DialogLocalizedKeys.ok.rawValue),
            attributes: [
                .font: FontManager.shared.regularFont(forLanguage: language ?? "km", fontFromconfig: DefaultAppearance.shared.fontEnglish,size: FixFontSize.contentText),
                .foregroundColor: DefaultAppearance.shared.onPrimaryColor,
                
            ]
        )
        buttonOk.setAttributedTitle(okTitle, for: .normal)
        
//        buttonOk.tintColor = DefaultAppearance.shared.primaryColor
//        buttonOk.setTitleColor(DefaultAppearance.shared.onPrimaryColor, for:.normal)
//        buttonOk.titleLabel?.font = FontManager.shared.regularFont(forLanguage: language ?? "km", size: FixFontSize.contentText)
//        
        
        
    }
    
    func configure(
            iconImage: Bool,
            message: String,
            okButtonTitle: String,
            cancelButtonTitle: String,
            okHandler: @escaping () -> Void,
            cancelHandler: @escaping () -> Void
    ) {
        
        DispatchQueue.main.async {
            
            if let icon = self.icon {
                icon.isHidden = iconImage
            }
                    
            if let enableImage = self.enableImage {
                enableImage.isHidden = !iconImage
            }
            if let messageLabel = self.lblMessage {
                messageLabel.text = message
            }
            if let okButton = self.buttonOk {
                okButton.setTitle(okButtonTitle, for: .normal)
            }
            if let cancelButton = self.buttonCancel {
                cancelButton.setTitle(cancelButtonTitle, for: .normal)
            }
            
            self.okActionHandler = okHandler
            self.cancelActionHandler = cancelHandler
        }
    }
    
    @IBAction func cancanAction(_ sender: Any) {
        dismiss(animated: true) {
          self.cancelActionHandler?()
        }
    }
    
    @IBAction func okAction(_ sender: Any) {
        dismiss(animated: true) {
            self.okActionHandler?()
        }
    }
    func showCustomAlert(
            from presentingViewController: UIViewController,
            isDefaultIcon: Bool,
            message: String,
            okHandler: @escaping () -> Void,
            cancelHandler: @escaping () -> Void
        ) {
            let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
            guard let alertView = storyboard.instantiateViewController(withIdentifier: "CustomAlertView") as? CustomAlertView else {
                return
            }

            alertView.modalPresentationStyle = .overFullScreen
            alertView.modalTransitionStyle = .crossDissolve

            // Pass the image using `UIImage(systemName:)` or `UIImage(named:)`
            alertView.configure(
                iconImage: isDefaultIcon,
                message: message,
                okButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.ok.rawValue),
                cancelButtonTitle: B24PaymentSdkHelper.localized(DialogLocalizedKeys.cancel.rawValue),
                okHandler: okHandler,
                cancelHandler: cancelHandler
            )

            // Present the alert from the calling view controller
            presentingViewController.present(alertView, animated: true)
        }
}
