//
//  WalletSuccessViewController.swift
//  B24PaymentSdk
//
//  Created by visal ny on 5/2/25.
//

import UIKit

class WalletSuccessViewController: UIViewController {

    @IBOutlet weak var bgContainer: UIView!
    @IBOutlet weak var successTitle: UILabel!
    @IBOutlet weak var subTitle: UILabel!
    @IBOutlet weak var buttonDone: UIButton!
    weak var presentingWalletVC: UIViewController?
    weak var bottomSheetVC: BottomSheetViewController?
    
    var language:String = "km"
    override func viewDidLoad() {
        super.viewDidLoad()
        
        view.backgroundColor = DefaultAppearance.shared.screenBgColor
        
        getSharePref()
        
        B24PaymentSdkHelper.getCurrentLanguage(language: language)
        
        applyAppearance()

        // Do any additional setup after loading the view.
        
        
    }
    
    private func getSharePref(){
        if let languageCode = SharedPreferenceManager.getString(forKey: SharePrefKey.lanuageCode.rawValue){
            language = languageCode
        }else{
            language = "km"
        }
    }
    
    private func applyAppearance(){
        bgContainer.backgroundColor = DefaultAppearance.shared.screenBgColor
        successTitle.text = B24PaymentSdkHelper.localized(WalletSuccessLocalizedKeys.title.rawValue)
        successTitle.font = FontManager.shared.boldFont(forLanguage: language, size: FixFontSize.cardTitle)
        successTitle.textColor = DefaultAppearance.shared.primaryLabelColor
        
        subTitle.text = B24PaymentSdkHelper.localized(WalletSuccessLocalizedKeys.sub_title.rawValue)
        subTitle.font = FontManager.shared.regularFont(forLanguage: language, size: FixFontSize.cardSubTitle)
        subTitle.textColor = DefaultAppearance.shared.primaryLabelColor
        

        buttonDone.backgroundColor = DefaultAppearance.shared.primaryColor
        buttonDone.layer.cornerRadius = 8
        let topupAttributedTitle = NSAttributedString(
            string: B24PaymentSdkHelper.localized(WalletSuccessLocalizedKeys.done.rawValue),
                    attributes: [
                        .font: FontManager.shared.regularFont(forLanguage: self.language, size: FixFontSize.buttonText),
                        .foregroundColor: DefaultAppearance.shared.onPrimaryColor
                    ]
                )
        self.buttonDone.setAttributedTitle(topupAttributedTitle, for: .normal)
        
        
    }
    
    
    @IBAction func doneAction(_ sender: Any) {
        
        let storyboard = UIStoryboard(name: "InstantPaymentMethodView", bundle: B24PaymentSdkHelper.frameworkBundle())
        if let navigationController = self.navigationController {
            // If inside an existing navigation controller, push new views
            if let instantPMViewController = storyboard.instantiateViewController(withIdentifier: "InstantPMView") as? InstantPMView {
                navigationController.pushViewController(instantPMViewController, animated: true)
            }

            if let accountDetailViewController = storyboard.instantiateViewController(withIdentifier: "AccountDetailView") as? AccountDetailView {
                navigationController.pushViewController(accountDetailViewController, animated: true)
        
            }
        } else {
            
            if let instantPMViewController = storyboard.instantiateViewController(withIdentifier: "InstantPMView") as? InstantPMView {
                    let newNavigationController = UINavigationController(rootViewController: instantPMViewController)
            
                    // Push AccountDetailView on top of InstantPMView in the new stack
                    if let accountDetailViewController = storyboard.instantiateViewController(withIdentifier: "AccountDetailView") as? AccountDetailView {
                        newNavigationController.pushViewController(accountDetailViewController, animated: true)
                
                    }
            
                    // Present the new navigation controller modally
                    newNavigationController.modalPresentationStyle = .fullScreen
                        self.present(newNavigationController, animated: true, completion: nil)
                    }
                           
        }
        
    }


}
